/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.common;

import fxc.app.Configurator;
import fxc.app.gui.SelectorItem;
import fxc.app.gui.common.ClosableScreen;
import fxc.app.res.ResourceId;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import ru.softlogic.config.add.GuiConfiguration;

public class GuiScreen
extends ClosableScreen {
    private final Configurator conf;
    @FXML
    private ComboBox<SelectorItem<String>> cbSize;
    @FXML
    private CheckBox cbShowCursor;
    @FXML
    private CheckBox cbOnTop;

    public GuiScreen(Configurator conf) {
        super(conf);
        this.conf = conf;
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        this.cbSize.getItems().clear();
        this.cbSize.getItems().add(new SelectorItem<String>(ResourceId.BUNDLE.getString("gui.size.fullscreen"), ""));
        this.cbSize.getItems().add(new SelectorItem<String>("800x600", "800x600"));
        this.cbSize.getItems().add(new SelectorItem<String>("1024x768", "1024x768"));
        this.cbSize.getItems().add(new SelectorItem<String>("1366x768", "1024x768"));
        this.cbSize.getItems().add(new SelectorItem<String>("1280x1024", "1280x1024"));
        this.cbSize.getItems().add(new SelectorItem<String>("1440x900", "1440x900"));
    }

    @FXML
    private void apply() {
        String size = (String)((SelectorItem)this.cbSize.getSelectionModel().getSelectedItem()).getData();
        this.conf.setGuiConfig(new GuiConfiguration(size, this.cbShowCursor.isSelected(), this.cbOnTop.isSelected()));
        this.close();
    }

    @Override
    public void beforeOpen() {
        GuiConfiguration gc = this.conf.getGuiConfig();
        if (gc != null) {
            this.cbSize.getSelectionModel().select(new SelectorItem<String>(null, gc.getSize()));
            if (this.cbSize.getSelectionModel().getSelectedIndex() < 0) {
                this.cbSize.getSelectionModel().select(0);
            }
            this.cbShowCursor.setSelected(gc.isShowCursor());
            this.cbOnTop.setSelected(gc.isOnTop());
        } else {
            this.cbSize.getSelectionModel().select(0);
            this.cbShowCursor.setSelected(false);
            this.cbOnTop.setSelected(true);
        }
    }

    @Override
    public void afrerSearch() {
    }
}

