/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.common;

import fxc.app.Configurator;
import fxc.app.gui.common.BaseHardwareScreen;
import fxc.app.res.LoggerId;
import fxc.app.task.dev.bvr.CvrTestTask;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hdw.base.SerialDevConfiguration;
import ru.softlogic.hdw.dev.cashacc.CvrConfiguration;
import ru.softlogic.hdw.dev.cashacc.CvrOptions;
import ru.softlogic.io.serial.SerialPort;

public class CoinAccScreen
extends BaseHardwareScreen {
    private final Configurator conf;
    private final Logger log;
    @FXML
    private ComboBox cbSorter;

    public CoinAccScreen(Configurator conf) {
        super(conf, "cvr");
        this.conf = conf;
        this.log = LoggerId.LOG;
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        this.cbSorter.getItems().add((Object)resources.getString("cvr.nosorter"));
    }

    @Override
    protected void updateConf(DeviceDescription desc, SerialPort port) throws Exception {
        this.conf.setCoinAcc(new CvrConfiguration(this.cbEnable.isSelected(), desc.getType(), port, new CvrOptions(null)));
    }

    @Override
    protected void removeConf() {
        this.conf.setCoinAcc(null);
    }

    @Override
    protected boolean hasConf() {
        return this.conf.getCoinAcc() != null;
    }

    @Override
    public void beforeOpen() {
        this.log.info((Object)"Before open");
        CvrConfiguration cvr = this.conf.getCoinAcc();
        this.log.info((Object)("Conf: " + cvr));
        this.processConnection((SerialDevConfiguration)cvr);
        if (cvr == null) {
            this.cbSorter.getSelectionModel().select(0);
        } else {
            this.cbSorter.getSelectionModel().select((Object)cvr.getOptions().getSorterProfile());
            if (this.cbSorter.getSelectionModel().getSelectedIndex() < 0) {
                this.cbSorter.getSelectionModel().select(0);
            }
        }
    }

    @FXML
    private void runTest() {
        this.conf.getTaskExecutor().add(new CvrTestTask(this.conf, this.getSelectedDescription().getType(), this.getSelectedPort()));
    }
}

