/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.common;

import fxc.app.Configurator;
import fxc.app.gui.common.BaseHardwareScreen;
import fxc.app.res.LoggerId;
import javafx.fxml.FXML;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hdw.base.SerialDevConfiguration;
import ru.softlogic.hdw.dev.crd.CrdConfiguration;
import ru.softlogic.io.serial.SerialPort;

public class CardReaderScreen
extends BaseHardwareScreen {
    private final Configurator conf;
    private final Logger log;

    public CardReaderScreen(Configurator conf) {
        super(conf, "crd");
        this.conf = conf;
        this.log = LoggerId.LOG;
    }

    @Override
    public void beforeOpen() {
        CrdConfiguration bac = this.conf.getCardReader();
        this.processConnection((SerialDevConfiguration)bac);
    }

    @Override
    protected void updateConf(DeviceDescription desc, SerialPort port) throws Exception {
        this.conf.setCardReader(new CrdConfiguration(this.cbEnable.isSelected(), desc.getType(), port));
    }

    @Override
    protected void removeConf() {
        this.conf.setCardReader(null);
    }

    @Override
    protected boolean hasConf() {
        return this.conf.getCardReader() != null;
    }

    @FXML
    private void runTest() {
    }
}

