/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.common;

import fxc.app.Configurator;
import fxc.app.gui.common.BaseHardwareScreen;
import fxc.app.gui.ctrl.digital.DigitalFieldController;
import fxc.app.gui.ctrl.digital.DigitalKeyboardOptions;
import fxc.app.res.LoggerId;
import fxc.app.res.ResourceId;
import fxc.app.task.dev.cvd.CvdTestTask;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.Pane;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.base.SerialDevConfiguration;
import ru.softlogic.hdw.dev.cvd.CardDispenserFactory;
import ru.softlogic.hdw.dev.cvd.CvdConfiguration;
import ru.softlogic.hdw.dev.cvd.CvdDescriptor;
import ru.softlogic.hdw.dev.cvd.CvdOptions;
import ru.softlogic.io.serial.SerialPort;

public class CardDispScreen
extends BaseHardwareScreen {
    private final Configurator app;
    private CvdConfiguration cnf;
    private final Logger log;
    private CvdDescriptor descriptor;
    @FXML
    private Pane rejectPane;
    @FXML
    private DigitalFieldController mainBoxCapacityController;
    @FXML
    private DigitalFieldController rejectBoxCapacityController;
    @FXML
    private DigitalFieldController rejectTimeoutController;
    @FXML
    private CheckBox cbHasBarcode;
    @FXML
    private CheckBox cbCheckBarcode;

    public CardDispScreen(Configurator conf) {
        super(conf, "cvd");
        this.app = conf;
        this.log = LoggerId.LOG;
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        this.mainBoxCapacityController.setOptions(new DigitalKeyboardOptions(20, 500, 3, 1, ResourceId.BUNDLE.getString("cvd.cap.main")));
        this.rejectBoxCapacityController.setOptions(new DigitalKeyboardOptions(10, 100, 3, 1, ResourceId.BUNDLE.getString("cvd.cap.reject")));
        this.rejectTimeoutController.setOptions(new DigitalKeyboardOptions(20, 45, 2, 1, ResourceId.BUNDLE.getString("cvd.reject.timeout")));
        this.cbCheckBarcode.visibleProperty().bind((ObservableValue)this.cbHasBarcode.selectedProperty());
    }

    @Override
    protected void onChangeDeviceDescription(DeviceDescription description) {
        super.onChangeDeviceDescription(description);
        this.descriptor = null;
        this.rejectPane.setVisible(true);
        if (description != null) {
            try {
                this.descriptor = CardDispenserFactory.createDescriptor((String)description.getType());
                this.rejectPane.setVisible(this.descriptor.isFeatureSupport(1));
                if (this.descriptor.isFeatureSupport(2)) {
                    this.cbHasBarcode.setSelected(true);
                    this.cbHasBarcode.setDisable(true);
                    this.cbHasBarcode.setVisible(true);
                } else if (this.descriptor.isFeatureSupport(4)) {
                    this.cbHasBarcode.setSelected(false);
                    this.cbHasBarcode.setDisable(false);
                    this.cbHasBarcode.setVisible(true);
                } else {
                    this.cbHasBarcode.setSelected(false);
                    this.cbHasBarcode.setVisible(false);
                }
            }
            catch (CreatingException ex) {
                this.log.info((Object)"Error on create descriptor", (Throwable)ex);
            }
            if (this.cnf != null && this.cnf.getOptions() != null && this.cnf.getType().equals(description.getType())) {
                this.setOptions(this.cnf.getOptions());
            } else {
                this.setOptions(CardDispenserFactory.createDefaultOptionsQuietly((String)description.getType()));
            }
        } else {
            this.mainBoxCapacityController.setValue(0);
            this.rejectBoxCapacityController.setValue(0);
            this.rejectTimeoutController.setValue(0);
        }
    }

    private void setOptions(CvdOptions co) {
        this.mainBoxCapacityController.setValue(co.getMainBoxCapacity());
        this.rejectBoxCapacityController.setValue(co.getRejectBoxCapacity());
        this.rejectTimeoutController.setValue(co.getRejectTimeout());
    }

    @Override
    protected void updateConf(DeviceDescription desc, SerialPort port) throws Exception {
        this.cnf = new CvdConfiguration(this.cbEnable.isSelected(), desc.getType(), port, this.buildConfiguration());
        this.app.setCardDisp(this.cnf);
    }

    private CvdOptions buildConfiguration() {
        if (this.descriptor != null && this.descriptor.isFeatureSupport(1)) {
            return new CvdOptions(this.mainBoxCapacityController.getValue(), this.rejectBoxCapacityController.getValue(), this.rejectTimeoutController.getValue(), this.cbHasBarcode.isSelected(), this.cbCheckBarcode.isSelected());
        }
        return new CvdOptions(this.mainBoxCapacityController.getValue(), 0, 0, this.cbHasBarcode.isSelected(), this.cbCheckBarcode.isSelected());
    }

    @Override
    protected void removeConf() {
        this.app.setCardDisp(null);
    }

    @Override
    protected boolean hasConf() {
        return this.app.getCardDisp() != null;
    }

    @FXML
    protected void runTest() {
        this.app.getTaskExecutor().add(new CvdTestTask(this.app, this.getSelectedDescription().getType(), this.getSelectedPort(), this.buildConfiguration()));
    }

    @Override
    public void beforeOpen() {
        this.cnf = this.app.getCardDisp();
        this.processConnection((SerialDevConfiguration)this.cnf);
    }
}

