/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.common;

import fxc.app.Configurator;
import fxc.app.gui.common.BaseHardwareScreen;
import fxc.app.task.dev.BillDispTestTask;
import javafx.fxml.FXML;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hdw.base.SerialDevConfiguration;
import ru.softlogic.hdw.dev.cashdisp.CdmConfiguration;
import ru.softlogic.hdw.dev.cashdisp.CdmOptions;
import ru.softlogic.io.serial.SerialPort;

public class BillDispScreen
extends BaseHardwareScreen {
    private final Configurator conf;
    private CdmConfiguration configuration;

    public BillDispScreen(Configurator conf) {
        super(conf, "bdm");
        this.conf = conf;
    }

    @Override
    protected void updateConf(DeviceDescription desc, SerialPort port) throws Exception {
        this.conf.setBillDisp(new CdmConfiguration(this.cbEnable.isSelected(), desc.getType(), port, new CdmOptions()));
    }

    @Override
    protected void removeConf() {
        this.conf.setBillDisp(null);
    }

    @Override
    protected boolean hasConf() {
        return this.conf.getBillDisp() != null;
    }

    @FXML
    private void runTest() {
        BillDispTestTask testTask = new BillDispTestTask(this.conf, this.getSelectedDescription().getType(), this.getSelectedPort(), new CdmOptions());
        this.conf.getTaskExecutor().add(testTask);
    }

    @Override
    public void beforeOpen() {
        this.configuration = this.conf.getBillDisp();
        this.processConnection((SerialDevConfiguration)this.configuration);
    }
}

