/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.common;

import fxc.app.Configurator;
import fxc.app.gui.common.BaseHardwareScreen;
import fxc.app.res.LoggerId;
import fxc.app.task.dev.bvr.BvrTestTask;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.base.SerialDevConfiguration;
import ru.softlogic.hdw.dev.cashacc.BvrConfiguration;
import ru.softlogic.hdw.dev.cashacc.BvrOptions;
import ru.softlogic.hdw.dev.cashacc.CashAcceptorDescriptor;
import ru.softlogic.hdw.dev.cashacc.CashAcceptorFactory;
import ru.softlogic.io.serial.SerialPort;

public class BillAccScreen
extends BaseHardwareScreen {
    private final Configurator conf;
    private CashAcceptorDescriptor descriptor;
    private final Logger log;
    @FXML
    private CheckBox cbUseCoin;

    public BillAccScreen(Configurator conf) {
        super(conf, "bvr");
        this.conf = conf;
        this.log = LoggerId.LOG;
    }

    @Override
    public void beforeOpen() {
        BvrConfiguration bac = this.conf.getBillAcc();
        this.processConnection((SerialDevConfiguration)bac);
        this.cbUseCoin.setSelected(bac == null ? false : bac.getOptions().isCoinAccConnected());
    }

    @Override
    protected void onChangeDeviceDescription(DeviceDescription description) {
        super.onChangeDeviceDescription(description);
        this.cbUseCoin.setDisable(true);
        if (description != null) {
            try {
                this.descriptor = CashAcceptorFactory.createBillAcceptorDescriptor((String)description.getType());
                boolean sup = this.descriptor.isFeatureSupport(1);
                this.cbUseCoin.setDisable(!sup);
                if (!sup) {
                    this.cbUseCoin.setSelected(false);
                }
            }
            catch (CreatingException ex) {
                this.log.error((Object)"Error on create descriptor", (Throwable)ex);
            }
        }
    }

    @Override
    protected void updateConf(DeviceDescription desc, SerialPort port) throws Exception {
        this.conf.setBillAcc(new BvrConfiguration(this.cbEnable.isSelected(), desc.getType(), port, this.getOptions()));
    }

    @Override
    protected void removeConf() {
        this.conf.setBillAcc(null);
    }

    @Override
    protected boolean hasConf() {
        return this.conf.getBillAcc() != null;
    }

    private BvrOptions getOptions() {
        return new BvrOptions(this.cbUseCoin.isSelected(), null);
    }

    @FXML
    private void runTest() {
        this.conf.getTaskExecutor().add(new BvrTestTask(this.conf, this.getSelectedDescription().getType(), this.getSelectedPort(), this.getOptions()));
    }
}

