/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.common;

import fxc.app.Configurator;
import fxc.app.ScanTask;
import fxc.app.gui.SelectorItem;
import fxc.app.gui.common.ClosableScreen;
import fxc.app.gui.ctrl.ports.PortSettingController;
import fxc.app.gui.oth.Dialog;
import fxc.app.gui.oth.DialogListener;
import fxc.app.model.Environment;
import fxc.app.res.LoggerId;
import fxc.app.res.ResourceId;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.search.ConnectedDevice;
import ru.softlogic.hdw.base.SerialDevConfiguration;
import ru.softlogic.io.PortType;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;

public abstract class BaseHardwareScreen
extends ClosableScreen {
    private final String devClass;
    private final Configurator conf;
    private List<DeviceDescription> dds;
    private final Logger log;
    @FXML
    protected ComboBox<SelectorItem<DeviceDescription>> cbType;
    @FXML
    protected Button bSearch;
    @FXML
    protected Button bTypeProp;
    @FXML
    protected Button bExit;
    @FXML
    protected Button bSave;
    @FXML
    protected Button bTest;
    @FXML
    protected CheckBox cbEnable;
    @FXML
    protected PortSettingController portSettingController;

    public BaseHardwareScreen(Configurator conf, String devClass) {
        super(conf);
        this.conf = conf;
        this.devClass = devClass;
        this.log = LoggerId.LOG;
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.cbType.getItems().clear();
        this.cbType.getItems().add(new SelectorItem<Object>(resources.getString("value.notselected"), null));
        this.dds = new LinkedList<DeviceDescription>();
        if (Environment.getDescriptions() != null) {
            for (DeviceDescription dd : Environment.getDescriptions()) {
                if (!this.devClass.equals(dd.getCategory()) || dd.isHidden()) continue;
                this.cbType.getItems().add(new SelectorItem<DeviceDescription>(dd.getName(), dd));
                this.dds.add(dd);
            }
        }
        this.cbType.valueProperty().addListener((observable, oldValue, newValue) -> this.onChangeDeviceDescription(this.getSelectedDescription()));
        if (this.bTest != null) {
            this.bTest.disableProperty().bind((ObservableValue)this.cbType.getSelectionModel().selectedIndexProperty().isEqualTo(0).or((ObservableBooleanValue)this.portSettingController.getSelectedProperty().not()));
        }
    }

    protected DeviceDescription getSelectedDescription() {
        return (DeviceDescription)((SelectorItem)this.cbType.getSelectionModel().getSelectedItem()).getData();
    }

    protected SerialPort getSelectedPort() {
        return this.portSettingController.getSerialPort();
    }

    @FXML
    protected final void search() {
        this.conf.getTaskExecutor().add(new ScanTask(this.conf, this.dds, this, false));
    }

    @FXML
    protected void apply() {
        DeviceDescription dd = this.getSelectedDescription();
        SerialPort port = this.getSelectedPort();
        this.log.info((Object)("Apply: " + dd + ", port=" + port));
        if (dd != null) {
            this.log.info((Object)"Update conf");
            try {
                this.updateConf(dd, port);
                this.log.info((Object)"Done, close panel");
                this.close();
            }
            catch (Exception ex) {
                this.log.error((Object)"Error on update conf", (Throwable)ex);
                String msg = ex.getMessage();
                this.conf.showDialog(new Dialog(ResourceId.BUNDLE.getString("dialog.title.error"), msg, ResourceId.BUNDLE.getString("dialog.btn.ok")), null);
            }
        } else if (this.hasConf()) {
            this.log.info((Object)"Ask about remove configuration");
            this.conf.showDialog(new Dialog(ResourceId.BUNDLE.getString("dialog.title.warning"), ResourceId.BUNDLE.getString("dialog.msg.delete_device"), ResourceId.BUNDLE.getString("dialog.btn.delete"), ResourceId.BUNDLE.getString("dialog.btn.cancel")), new DialogListener(){

                @Override
                public void onSelect(int buttonId) {
                    if (buttonId == 0) {
                        BaseHardwareScreen.this.log.info((Object)"Remove configuration");
                        BaseHardwareScreen.this.removeConf();
                        BaseHardwareScreen.this.log.info((Object)"Remove connected device");
                        BaseHardwareScreen.this.conf.removeConnectedDevice(BaseHardwareScreen.this.devClass);
                        BaseHardwareScreen.this.close();
                    } else {
                        BaseHardwareScreen.this.log.info((Object)"Nothing to do");
                    }
                }
            });
        } else {
            this.log.info((Object)"Skip modification");
            this.close();
        }
    }

    @Override
    public void afrerSearch() {
        this.log.info((Object)"After search");
        ConnectedDevice cd = this.conf.getConnectedDevice(this.devClass);
        this.log.info((Object)("Connected device for " + this.devClass + ": " + cd));
        if (cd == null) {
            this.cbType.getSelectionModel().select(0);
            if (this.portSettingController != null) {
                this.portSettingController.setPortName(null);
                this.portSettingController.setParams(new SerialParams(9600));
            }
        } else {
            this.cbType.getSelectionModel().select(new SelectorItem<DeviceDescription>(null, cd.getDescription()));
            if (this.portSettingController != null) {
                this.portSettingController.setPortName(cd.getPort().getName());
                this.portSettingController.setParams(cd.getPort().getParams());
            }
        }
    }

    protected void processConnection(SerialDevConfiguration configuration) {
        this.portSettingController.showingPorts(PortType.SerialPort);
        if (configuration == null) {
            this.cbEnable.setSelected(false);
            this.afrerSearch();
        } else {
            this.cbEnable.setSelected(configuration.isEnable());
            if (configuration.getPort() != null) {
                this.portSettingController.setParams(configuration.getPort().getParams());
                this.portSettingController.setPortName(configuration.getPort().getName());
            } else {
                this.portSettingController.setPortName(null);
                this.portSettingController.setParams(new SerialParams(9600));
            }
            this.update(this.cbType, new SelectorItem<DeviceDescription>(null, Environment.getById(this.devClass, configuration.getType())));
        }
    }

    @Override
    public void beforeOpen() {
    }

    protected void onChangeDeviceDescription(DeviceDescription description) {
        this.log.info((Object)("Change device type: " + description));
    }

    protected abstract void updateConf(DeviceDescription var1, SerialPort var2) throws Exception;

    protected abstract void removeConf();

    protected abstract boolean hasConf();
}

