/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui.common;

import fxc.app.Configurator;
import fxc.app.gui.common.BaseHardwareScreen;
import fxc.app.res.LoggerId;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.base.SerialDevConfiguration;
import ru.softlogic.hdw.dev.barcode.BarConfiguration;
import ru.softlogic.hdw.dev.barcode.BarOptions;
import ru.softlogic.hdw.dev.barcode.BarcodeFactory;
import ru.softlogic.hdw.dev.barcode.Descriptor;
import ru.softlogic.io.serial.SerialPort;

public class BarcodeScreen
extends BaseHardwareScreen {
    private final Configurator conf;
    private final Logger log;

    public BarcodeScreen(Configurator conf) {
        super(conf, "bar");
        this.conf = conf;
        this.log = LoggerId.LOG;
    }

    @Override
    public void beforeOpen() {
        BarConfiguration c = this.conf.getBarcode();
        this.processConnection((SerialDevConfiguration)c);
    }

    @Override
    protected void updateConf(DeviceDescription desc, SerialPort port) throws Exception {
        this.conf.setBarcode(new BarConfiguration(this.cbEnable.isSelected(), desc.getType(), port, new BarOptions()));
    }

    @Override
    protected void onChangeDeviceDescription(DeviceDescription description) {
        super.onChangeDeviceDescription(description);
        this.portSettingController.getComboBox().setDisable(true);
        if (description != null) {
            try {
                Descriptor desc = BarcodeFactory.createDescriptor((String)description.getType());
                if (desc.isFeatureSupport(1)) {
                    this.portSettingController.getComboBox().getSelectionModel().select(0);
                } else {
                    this.portSettingController.getComboBox().setDisable(false);
                }
            }
            catch (CreatingException ex) {
                this.log.error((Object)"Error on  create barcode descriptor", (Throwable)ex);
            }
        }
    }

    @Override
    protected void removeConf() {
        this.conf.setBarcode(null);
    }

    @Override
    protected boolean hasConf() {
        return this.conf.getBarcode() != null;
    }
}

