/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui;

import fxc.app.gui.ctrl.digital.DigitalFieldController;
import fxc.app.gui.ctrl.digital.DigitalKeyboardOptions;
import javafx.event.EventHandler;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;

public class NumericFilter
implements EventHandler<KeyEvent> {
    private final TextField tf;
    private final int maxLen;
    private final DigitalFieldController dfc;

    public NumericFilter(TextField tf, int maxLen, DigitalFieldController dfc) {
        this.tf = tf;
        this.maxLen = maxLen;
        this.dfc = dfc;
    }

    public void handle(KeyEvent t) {
        int ml;
        DigitalKeyboardOptions opt = this.dfc.getOptions();
        int n = ml = opt != null ? opt.getMaxLen() : this.maxLen;
        if ("+".equals(t.getCharacter())) {
            try {
                int val = Integer.parseInt(this.tf.getText());
                this.tf.setText(opt != null && val + 1 <= opt.getMax() ? Integer.toString(val + 1) : this.tf.getText());
            }
            catch (NumberFormatException val) {
                // empty catch block
            }
            t.consume();
        } else if ("-".equals(t.getCharacter())) {
            try {
                int val = Integer.parseInt(this.tf.getText());
                this.tf.setText(opt != null && val - 1 >= opt.getMin() ? Integer.toString(val - 1) : this.tf.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            t.consume();
        } else if (!t.getCharacter().matches("\\d+") || this.tf.getText().length() + t.getCharacter().length() > ml) {
            t.consume();
        }
    }
}

