/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.gui;

import fxc.app.gui.common.Screen;
import fxc.app.gui.oth.CheckConnectionScreen;
import fxc.app.gui.oth.DialogScreen;
import fxc.app.gui.oth.GenerateKeyDialog;
import fxc.app.gui.oth.KeySelectScreen;
import fxc.app.gui.oth.ScanScreen;
import fxc.app.gui.oth.ServerSelectScreen;
import java.util.Map;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

public class Gui {
    private final StackPane pane;
    private final Map<String, Screen> screens;
    private ScanScreen scanScreen;
    private DialogScreen dialog2x;
    private DialogScreen dialog1x;
    private KeySelectScreen keySelectScreen;
    private ServerSelectScreen srvSelectScreen;
    private GenerateKeyDialog generateKeyDialog;
    private CheckConnectionScreen checkConnectionScreen;

    public Gui(StackPane pane, Map<String, Screen> screens) {
        if (pane == null) {
            throw new NullPointerException("StackPane is null");
        }
        if (screens == null) {
            throw new NullPointerException("Screens is null");
        }
        this.pane = pane;
        this.screens = screens;
    }

    public void open(String url) {
        this.pane.getChildren().clear();
        Screen sc = this.screens.get(url);
        sc.beforeOpen();
        this.pane.getChildren().add((Object)sc.getParent());
    }

    public void openPopup(Pane pane) {
        this.pane.getChildren().add((Object)pane);
    }

    public void clearPopup(Pane pane) {
        this.pane.getChildren().remove((Object)pane);
    }

    public ScanScreen getScanScreen() {
        return this.scanScreen;
    }

    public void setScanScreen(ScanScreen scanScreen) {
        this.scanScreen = scanScreen;
    }

    public DialogScreen getDialog2x() {
        return this.dialog2x;
    }

    public void setDialog2x(DialogScreen dialog2x) {
        this.dialog2x = dialog2x;
    }

    public DialogScreen getDialog1x() {
        return this.dialog1x;
    }

    public void setDialog1x(DialogScreen dialog1x) {
        this.dialog1x = dialog1x;
    }

    public KeySelectScreen getKeySelectScreen() {
        return this.keySelectScreen;
    }

    public void setKeySelectScreen(KeySelectScreen keySelectScreen) {
        this.keySelectScreen = keySelectScreen;
    }

    public CheckConnectionScreen getCheckConnectionScreen() {
        return this.checkConnectionScreen;
    }

    public void setCheckConnectionScreen(CheckConnectionScreen checkConnectionScreen) {
        this.checkConnectionScreen = checkConnectionScreen;
    }

    public ServerSelectScreen getServerSelectScreen() {
        return this.srvSelectScreen;
    }

    public void setServerSelectScreen(ServerSelectScreen srvSelectScreen) {
        this.srvSelectScreen = srvSelectScreen;
    }

    public GenerateKeyDialog getGenerateKeyDialog() {
        return this.generateKeyDialog;
    }

    public void setGenerateKeyDialog(GenerateKeyDialog generateKeyDialog) {
        this.generateKeyDialog = generateKeyDialog;
    }
}

