/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.connect;

import fxc.app.Configurator;
import fxc.app.connect.RequestServerTask;
import fxc.app.gui.oth.Dialog;
import fxc.app.res.ResourceId;
import fxc.app.task.WaitTask;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import ru.softlogic.system.util.os.OsApi;

public class SyncTimeTask
extends WaitTask {
    private final Configurator conf;

    public SyncTimeTask(Configurator conf) {
        super(conf);
        this.conf = conf;
    }

    @Override
    protected void _onResult(Object object) {
        super._onResult(object);
        if (object instanceof Date) {
            OsApi instance = OsApi.getInstance();
            instance.setLocalTime((Date)object);
            this.showInfoDialog(ResourceId.BUNDLE.getString("dialog.msg.time.success"));
        } else if (object instanceof Exception) {
            this.showErrorDialog(((Exception)object).getMessage());
        } else {
            this.showErrorDialog(ResourceId.BUNDLE.getString("dialog.msg.time.error"));
        }
    }

    @Override
    public Object process() throws InterruptedException {
        try {
            ExecutorService threadPool = this.conf.getThreadPool();
            Future<Date> future = threadPool.submit(new RequestServerTask(this.conf, null));
            return future.get(30L, TimeUnit.SECONDS);
        }
        catch (ExecutionException | TimeoutException ex) {
            return ex;
        }
    }

    private void showErrorDialog(String msg) {
        this.showDialog(ResourceId.BUNDLE.getString("dialog.title.error"), msg);
    }

    private void showInfoDialog(String msg) {
        this.showDialog(ResourceId.BUNDLE.getString("dialog.title.warning"), msg);
    }

    private void showDialog(String title, String msg) {
        this.conf.showDialog(new Dialog(title, msg, ResourceId.BUNDLE.getString("dialog.btn.ok")), null);
    }
}

