/*
 * Decompiled with CFR 0.152.
 */
package fxc.app.connect;

import fxc.app.Configurator;
import fxc.app.connect.PingTaskListener;
import fxc.app.res.LoggerId;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import ru.softlogic.config.add.Proxy;
import ru.softlogic.config.add.ServerProfile;
import ru.softlogic.srv.connector.ConnConfiguration;
import ru.softlogic.srv.connector.ConnectorFactory;
import ru.softlogic.srv.connector.ConnectorType;
import ru.softlogic.srv.connector.ProxyConfiguration;
import ru.softlogic.srv.connector.ServerInterface;
import ru.softlogic.srv.utils.NetworkUtils;
import ru.softlogic.system.util.DaemonUtil;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.hwd.SerialExtractorApi;

public class RequestServerTask
implements Callable<Date> {
    private final Configurator conf;
    private final PingTaskListener taskListener;
    private final Logger log = LoggerId.LOG;

    public RequestServerTask(Configurator conf, PingTaskListener taskListener) {
        this.conf = conf;
        this.taskListener = taskListener;
    }

    @Override
    public Date call() throws Exception {
        try {
            boolean psReady;
            ServerProfile sp = this.conf.getServerProfile();
            File keyDir = PathUtils.getFilePath((String)"/key/");
            this.log.info((Object)("Configuration: " + this.conf.getConn()));
            ProxyConfiguration proxy = NetworkUtils.convertProxy((Proxy)this.conf.getConn().getProxy());
            ConnConfiguration conn = NetworkUtils.getConnConfiguration((ServerProfile)sp, (File)keyDir);
            String version = this.getTerminalVersion();
            ServerInterface serverInterface = ConnectorFactory.createConnector((ConnectorType)ConnectorType.WS, (ConnConfiguration)conn, (ProxyConfiguration)proxy, (long)SerialExtractorApi.getInstance().getConfigurationId(), (int)sp.getPointId(), () -> 0, () -> version + "/" + DaemonUtil.getUpdateBuild());
            Date pingResult = serverInterface.ping();
            boolean bl = psReady = pingResult != null;
            if (this.taskListener != null) {
                if (psReady) {
                    this.taskListener.onSeccess();
                } else {
                    this.taskListener.onError();
                }
            }
            return pingResult;
        }
        catch (Throwable ex) {
            this.log.error((Object)"Error on server request", ex);
            if (this.taskListener != null) {
                this.taskListener.onError();
            }
            return null;
        }
    }

    private String getTerminalVersion() {
        try {
            Field field = Class.forName("ru.softlogic.app.DaemonVersion").getField("version");
            field.setAccessible(true);
            return (String)field.get("");
        }
        catch (Throwable ex) {
            return "7.0.0";
        }
    }
}

