/*
 * Decompiled with CFR 0.152.
 */
package fxc.app;

import fxc.app.Configurator;
import fxc.app.gui.common.Screen;
import fxc.app.gui.oth.ScanRecord;
import fxc.app.gui.oth.ScanScreen;
import fxc.app.gui.oth.ScanScreenListener;
import fxc.app.model.Environment;
import fxc.app.res.LoggerId;
import fxc.app.task.GuiTask;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.search.ConnectedDevice;
import ru.softlogic.hardware.search.ExcludeSearchFilter;
import ru.softlogic.hardware.search.SearchFilter;
import ru.softlogic.hardware.search.SearchListener;
import ru.softlogic.hardware.search.SearchResult;
import ru.softlogic.hardware.search.UsbConnectedDevice;

public class ScanTask
extends GuiTask
implements ScanScreenListener {
    private final Configurator conf;
    private final List<DeviceDescription> dds;
    private final Screen screen;
    private final ScanScreen ss;
    private final Map<String, ScanRecord> ports;
    private boolean canceled;
    private boolean finished;
    private final Logger log = LoggerId.LOG;

    public ScanTask(Configurator conf, List<DeviceDescription> dds, Screen screen, boolean scanOnUsb) {
        this.conf = conf;
        this.dds = dds;
        this.screen = screen;
        this.ss = conf.getGui().getScanScreen();
        this.ports = new LinkedHashMap<String, ScanRecord>();
        for (String port : Environment.getSerialPorts()) {
            this.ports.put(port, new ScanRecord(port, "-", "-", "", ""));
        }
        if (scanOnUsb) {
            for (String port : Environment.getUsbPorts()) {
                this.ports.put(port, new ScanRecord(port, "-", "-", "", ""));
            }
        }
    }

    @Override
    protected void _onPreExecute() {
        this.log.info((Object)"onPreExecute");
        this.ss.setListener(this);
        this.updateScreen();
        this.ss.setInterval("-");
        this.conf.getGui().openPopup(this.ss.geRoot());
    }

    @Override
    protected void _onResult(Object object) {
        SearchResult sr = (SearchResult)object;
        this.log.info((Object)("Result: " + sr));
        this.ss.setInterval(String.format("%.2f", (double)sr.getTimeout() * 1.0 / 1000.0));
        this.finished = true;
        this.conf.setSearchResult(sr);
        if (this.screen != null) {
            this.screen.afrerSearch();
        }
        this.checkClose();
    }

    @Override
    public Object process() {
        List<ConnectedDevice> prev = this.conf.getConnectedDevices();
        this.log.info((Object)("Prev result: " + prev));
        return this.conf.getDeviceSearcher().search(this.ports.keySet().toArray(new String[this.ports.size()]), this.dds, Collections.emptyList(), (SearchFilter)new ExcludeSearchFilter(), (SearchListener)new GuiUpdater());
    }

    @Override
    public void onCancel() {
        this.canceled = true;
        this.conf.getDeviceSearcher().cancel();
        this.checkClose();
    }

    private void checkClose() {
        if (this.canceled && this.finished) {
            this.conf.getGui().clearPopup(this.ss.geRoot());
        }
    }

    private void updateScreen() {
        LinkedList<ScanRecord> records = new LinkedList<ScanRecord>();
        records.addAll(this.ports.values());
        this.ss.update(records);
    }

    private class GuiUpdater
    implements SearchListener {
        private GuiUpdater() {
        }

        public void onBegin(String port) {
            ScanTask.this.log.info((Object)("Begin: " + port));
        }

        public synchronized void onProgress(String port, DeviceDescription dd, String params) {
            ScanTask.this.log.info((Object)("progress: " + port + ", dd=" + dd + ", params=" + params));
            ScanRecord sr = (ScanRecord)ScanTask.this.ports.get(port);
            sr.setType(dd.getName());
            sr.setParams(params);
            Platform.runLater(() -> ScanTask.this.updateScreen());
        }

        public synchronized void onResult(String port, ConnectedDevice cd) {
            ScanTask.this.log.info((Object)("Result: " + port + ", cd=" + cd));
            ScanRecord sr = (ScanRecord)ScanTask.this.ports.get(port);
            sr.setFinish("+");
            if (cd == null) {
                sr.setParams("-");
                sr.setType("-");
            }
            sr.setFound(cd != null ? "+" : "-");
            Platform.runLater(() -> ScanTask.this.updateScreen());
        }

        public void onResult(String port, UsbConnectedDevice cd) {
            ScanTask.this.log.info((Object)("Result: " + port + ", cd=" + cd));
            ScanRecord sr = (ScanRecord)ScanTask.this.ports.get(port);
            sr.setFinish("+");
            if (cd == null) {
                sr.setParams("-");
                sr.setType("-");
            }
            sr.setFound(cd != null ? "+" : "-");
            Platform.runLater(() -> ScanTask.this.updateScreen());
        }
    }
}

