/*
 * Decompiled with CFR 0.152.
 */
package fxc.app;

import fxc.app.Application;
import fxc.app.Configurator;
import fxc.app.gui.Gui;
import fxc.app.gui.oth.Dialog;
import fxc.app.gui.oth.DialogCloseListener;
import fxc.app.gui.oth.DialogListener;
import fxc.app.gui.oth.DialogScreen;
import fxc.app.key.TerminalKey;
import fxc.app.key.TerminalKeyUtils;
import fxc.app.model.Environment;
import fxc.app.res.LoggerId;
import fxc.app.res.ResourceId;
import fxc.app.task.TaskExecutor;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import org.apache.log4j.Logger;
import ru.softlogic.config.ConfigurationIO;
import ru.softlogic.config.add.ConConfiguration;
import ru.softlogic.config.add.ConSection;
import ru.softlogic.config.add.GuiConfiguration;
import ru.softlogic.config.add.GuiSection;
import ru.softlogic.config.add.ServerProfile;
import ru.softlogic.hardware.search.ConnectedDevice;
import ru.softlogic.hardware.search.DeviceSearcher;
import ru.softlogic.hardware.search.SearchResult;
import ru.softlogic.hardware.search.UsbConnectedDevice;
import ru.softlogic.hdw.dev.barcode.BarConfiguration;
import ru.softlogic.hdw.dev.barcode.BarSection;
import ru.softlogic.hdw.dev.cashacc.BvrConfiguration;
import ru.softlogic.hdw.dev.cashacc.BvrSection;
import ru.softlogic.hdw.dev.cashacc.CvrConfiguration;
import ru.softlogic.hdw.dev.cashacc.CvrSection;
import ru.softlogic.hdw.dev.cashdisp.BdmSection;
import ru.softlogic.hdw.dev.cashdisp.CdmConfiguration;
import ru.softlogic.hdw.dev.cashdisp.CdmSection;
import ru.softlogic.hdw.dev.crd.CrdConfiguration;
import ru.softlogic.hdw.dev.crd.CrdSection;
import ru.softlogic.hdw.dev.cvd.CvdConfiguration;
import ru.softlogic.hdw.dev.cvd.CvdSection;
import ru.softlogic.hdw.dev.ioc.IocConfiguration;
import ru.softlogic.hdw.dev.ioc.IocSection;
import ru.softlogic.hdw.dev.modem.ModConfiguration;
import ru.softlogic.hdw.dev.modem.ModSection;
import ru.softlogic.hdw.dev.printer.PrtConfiguration;
import ru.softlogic.hdw.dev.printer.PrtSection;
import ru.softlogic.hdw.dev.sensors.SnrConfiguration;
import ru.softlogic.hdw.dev.sensors.SnrSection;
import ru.softlogic.hdw.dev.watchdog.WdtConfiguration;
import ru.softlogic.hdw.dev.watchdog.WdtSection;
import ru.softlogic.hdw.dev.webcam.WcmConfiguration;
import ru.softlogic.hdw.dev.webcam.WcmSection;
import ru.softlogic.ppp.ConnectionManager;

public class BaseApplication
implements Configurator,
Application,
DialogListener {
    private final TaskExecutor executor;
    private final Gui gui;
    private final Logger log = LoggerId.LOG;
    private DeviceSearcher searcher;
    private final ConnectionManager connectionManager;
    private final Map<String, ConnectedDevice> cds = new TreeMap<String, ConnectedDevice>();
    private final Map<String, UsbConnectedDevice> ucds = new TreeMap<String, UsbConnectedDevice>();
    private BvrConfiguration bvr;
    private CvrConfiguration cvr;
    private CdmConfiguration billDisp;
    private CdmConfiguration coinDisp;
    private CvdConfiguration cardDisp;
    private GuiConfiguration guiConfig;
    private BarConfiguration bar;
    private ModConfiguration mod;
    private WdtConfiguration wdt;
    private ConConfiguration conn;
    private PrtConfiguration prt;
    private SnrConfiguration snr;
    private IocConfiguration ioc;
    private WcmConfiguration wcm;
    private CrdConfiguration crd;
    private final ConfigurationIO io;
    private final File home;
    private ServerProfile profile;
    private final ExecutorService threadPool;

    public BaseApplication(TaskExecutor executor, ConnectionManager connectionManager, Gui gui, File home) {
        this.executor = executor;
        this.connectionManager = connectionManager;
        this.gui = gui;
        this.home = home;
        this.io = new ConfigurationIO(new File(home, "conf.xml"), this.log);
        this.threadPool = Executors.newFixedThreadPool(5);
    }

    @Override
    public Gui getGui() {
        return this.gui;
    }

    @Override
    public TaskExecutor getTaskExecutor() {
        return this.executor;
    }

    @Override
    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    @Override
    public DeviceSearcher getDeviceSearcher() {
        return this.searcher;
    }

    @Override
    public void start() {
        this.log.info((Object)"Start configurator application");
        String[] sp = Environment.getSerialPorts();
        String[] up = Environment.getUsbPorts();
        this.searcher = new DeviceSearcher((sp == null ? 5 : sp.length) + (up == null ? 0 : up.length), 5, true);
        this.gui.open("/fxc/pane/home.fxml");
    }

    @Override
    public void stop(int code) {
        this.log.info((Object)("Stop configurator application with code: " + code));
        this.threadPool.shutdown();
        this.searcher.shutdown();
        Platform.exit();
        System.exit(code);
    }

    @Override
    public void setSearchResult(SearchResult searchResult) {
        for (ConnectedDevice connectedDevice : searchResult.getDevices()) {
            this.cds.put(connectedDevice.getDescription().getCategory(), connectedDevice);
        }
        for (UsbConnectedDevice usbConnectedDevice : searchResult.getUsbDevices()) {
            this.ucds.put(usbConnectedDevice.getDescription().getCategory(), usbConnectedDevice);
        }
        this.log.info((Object)"Connected serial devices: ");
        for (ConnectedDevice connectedDevice : this.cds.values()) {
            this.log.info((Object)("    " + connectedDevice.getPort().asStr() + "->" + connectedDevice.getDescription()));
        }
        this.log.info((Object)"Connected usb devices: ");
        for (UsbConnectedDevice usbConnectedDevice : this.ucds.values()) {
            this.log.info((Object)("    " + usbConnectedDevice.getPort().asStr() + "->" + usbConnectedDevice.getDescription()));
        }
        this.log.info((Object)"--");
    }

    @Override
    public List<ConnectedDevice> getConnectedDevices() {
        return new ArrayList<ConnectedDevice>(this.cds.values());
    }

    @Override
    public ConnectedDevice getConnectedDevice(String type) {
        for (ConnectedDevice cd : this.cds.values()) {
            if (!cd.getDescription().getCategory().equals(type)) continue;
            return cd;
        }
        return null;
    }

    @Override
    public void removeConnectedDevice(String type) {
        this.cds.remove(type);
    }

    @Override
    public UsbConnectedDevice getUsbConnectedDevice(String type) {
        for (UsbConnectedDevice cd : this.ucds.values()) {
            if (!cd.getDescription().getCategory().equals(type)) continue;
            return cd;
        }
        return null;
    }

    @Override
    public void setBillAcc(BvrConfiguration bvr) {
        this.log.info((Object)("Update bill acceptor: " + bvr));
        this.bvr = bvr;
    }

    @Override
    public BvrConfiguration getBillAcc() {
        return this.bvr;
    }

    @Override
    public void setCoinAcc(CvrConfiguration cvr) {
        this.log.info((Object)("Update coin acceptor: " + cvr));
        this.cvr = cvr;
    }

    @Override
    public CvrConfiguration getCoinAcc() {
        return this.cvr;
    }

    @Override
    public void setBillDisp(CdmConfiguration cdm) {
        this.log.info((Object)("Update bill dispenser: " + cdm));
        this.billDisp = cdm;
    }

    @Override
    public CdmConfiguration getBillDisp() {
        return this.billDisp;
    }

    @Override
    public void setCardDisp(CvdConfiguration cvd) {
        this.log.info((Object)("Update card dispenser: " + cvd));
        this.cardDisp = cvd;
    }

    @Override
    public void setGuiConfig(GuiConfiguration guiConfig) {
        this.log.info((Object)("Update gui: " + guiConfig));
        this.guiConfig = guiConfig;
    }

    @Override
    public GuiConfiguration getGuiConfig() {
        return this.guiConfig;
    }

    @Override
    public CvdConfiguration getCardDisp() {
        return this.cardDisp;
    }

    @Override
    public File getPath(String file) {
        return new File(this.home, file);
    }

    @Override
    public void showDialog(Dialog dialog, DialogListener listener) {
        DialogScreen ds = dialog.getButtons().length == 1 ? this.gui.getDialog1x() : this.gui.getDialog2x();
        ds.init(dialog, new DialogCloseListener(this.gui, ds.getRoot(), listener));
        this.gui.openPopup(ds.getRoot());
    }

    @Override
    public void setBarcode(BarConfiguration bar) {
        this.log.info((Object)("Update barcode: " + bar));
        this.bar = bar;
    }

    @Override
    public BarConfiguration getBarcode() {
        return this.bar;
    }

    @Override
    public void setModem(ModConfiguration mod) {
        this.log.info((Object)("Update modem: " + mod));
        this.mod = mod;
    }

    @Override
    public ModConfiguration getModem() {
        return this.mod;
    }

    @Override
    public void setConn(ConConfiguration conn) {
        this.log.info((Object)("Update conn: " + conn));
        this.conn = conn;
    }

    @Override
    public ConConfiguration getConn() {
        return this.conn;
    }

    @Override
    public void updateConfiguration() {
        LinkedList<Object> secs = new LinkedList<Object>();
        if (this.conn != null) {
            secs.add(new ConSection(this.conn));
        }
        if (this.bvr != null) {
            secs.add(new BvrSection(this.bvr));
        }
        if (this.cvr != null) {
            secs.add(new CvrSection(this.cvr));
        }
        if (this.billDisp != null) {
            secs.add(new BdmSection(this.billDisp));
        }
        if (this.coinDisp != null) {
            secs.add(new CdmSection(this.coinDisp));
        }
        if (this.cardDisp != null) {
            secs.add(new CvdSection(this.cardDisp));
        }
        if (this.bar != null) {
            secs.add(new BarSection(this.bar));
        }
        if (this.mod != null) {
            secs.add(new ModSection(this.mod));
        }
        if (this.wdt != null) {
            secs.add(new WdtSection(this.wdt));
        }
        if (this.prt != null) {
            secs.add(new PrtSection(this.prt));
        }
        if (this.snr != null) {
            secs.add(new SnrSection(this.snr));
        }
        if (this.ioc != null) {
            secs.add(new IocSection(this.ioc));
        }
        if (this.wcm != null) {
            secs.add(new WcmSection(this.wcm));
        }
        if (this.crd != null) {
            secs.add(new CrdSection(this.crd));
        }
        secs.add(new GuiSection(this.guiConfig));
        try {
            this.io.update(secs);
            this.showDialog(new Dialog(ResourceId.BUNDLE.getString("dialog.title.info"), ResourceId.BUNDLE.getString("update_conf.success"), ResourceId.BUNDLE.getString("dialog.btn.ok")), null);
        }
        catch (Exception ex) {
            this.log.error((Object)ex);
            this.showDialog(new Dialog(ResourceId.BUNDLE.getString("dialog.title.error"), MessageFormat.format(ResourceId.BUNDLE.getString("update_conf.error"), ex.getMessage()), ResourceId.BUNDLE.getString("dialog.btn.ok")), null);
        }
    }

    @Override
    public void setWatchdog(WdtConfiguration wdt) {
        this.log.info((Object)("Update wdt: " + wdt));
        this.wdt = wdt;
    }

    @Override
    public WdtConfiguration getWatchDog() {
        return this.wdt;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public void closeConfiguration() {
        this.log.info((Object)"Ask about run payment software");
        this.showDialog(new Dialog(ResourceId.BUNDLE.getString("dialog.title.warning"), ResourceId.BUNDLE.getString("app.close.msg"), ResourceId.BUNDLE.getString("app.close.start"), ResourceId.BUNDLE.getString("app.close.close")), this);
    }

    @Override
    public void setPrinter(PrtConfiguration prt) {
        this.log.info((Object)("Update prt: " + prt));
        this.prt = prt;
    }

    @Override
    public PrtConfiguration getPrinter() {
        return this.prt;
    }

    @Override
    public void setServerProfile(ServerProfile profile) {
        this.profile = profile;
    }

    @Override
    public ServerProfile getServerProfile() {
        return this.profile;
    }

    @Override
    public void setSensor(SnrConfiguration snr) {
        this.snr = snr;
    }

    @Override
    public SnrConfiguration getSensor() {
        return this.snr;
    }

    @Override
    public void setIoc(IocConfiguration ioc) {
        this.ioc = ioc;
    }

    @Override
    public IocConfiguration getIoc() {
        return this.ioc;
    }

    @Override
    public WcmConfiguration getWebcam() {
        return this.wcm;
    }

    @Override
    public void setWebcam(WcmConfiguration wcm) {
        this.wcm = wcm;
    }

    @Override
    public void onSelect(int buttonId) {
        this.log.info((Object)("User make choice: " + buttonId));
        if (buttonId == 0) {
            this.stop(1);
        } else {
            this.stop(0);
        }
    }

    @Override
    public void loadTerminalKey(TerminalKey key) {
        this.log.info((Object)("load key: " + key));
        try {
            TerminalKeyUtils.save(key);
        }
        catch (Exception ex) {
            this.log.error((Object)ex);
            this.showDialog(new Dialog(ResourceId.BUNDLE.getString("dialog.title.error"), ResourceId.BUNDLE.getString("genkey.result.error"), ResourceId.BUNDLE.getString("dialog.btn.ok")), null);
        }
    }

    @Override
    public void setCoinDisp(CdmConfiguration cdm) {
        this.log.info((Object)("Update coin dispenser: " + cdm));
        this.coinDisp = cdm;
    }

    @Override
    public CdmConfiguration getCoinDisp() {
        return this.coinDisp;
    }

    @Override
    public void setCardReader(CrdConfiguration crd) {
        this.log.info((Object)("Update card reader: " + crd));
        this.crd = crd;
    }

    @Override
    public CrdConfiguration getCardReader() {
        return this.crd;
    }
}

