/*
 * Decompiled with CFR 0.152.
 */
package fxc;

import fxc.CloseListener;
import fxc.DigitalFieldListenerImpl;
import fxc.LetterFieldListenerImpl;
import fxc.PortSettingListenerImpl;
import fxc.app.BaseApplication;
import fxc.app.Configurator;
import fxc.app.DescByNameComparator;
import fxc.app.gui.Gui;
import fxc.app.gui.common.BarcodeScreen;
import fxc.app.gui.common.BillAccScreen;
import fxc.app.gui.common.BillDispScreen;
import fxc.app.gui.common.CardDispScreen;
import fxc.app.gui.common.CardReaderScreen;
import fxc.app.gui.common.CoinAccScreen;
import fxc.app.gui.common.CoinDispScreen;
import fxc.app.gui.common.GuiScreen;
import fxc.app.gui.common.HomeScreen;
import fxc.app.gui.common.IocScreen;
import fxc.app.gui.common.LoadScreen;
import fxc.app.gui.common.ModemScreen;
import fxc.app.gui.common.PrnScreen;
import fxc.app.gui.common.Screen;
import fxc.app.gui.common.SensorScreen;
import fxc.app.gui.common.SrvScreen;
import fxc.app.gui.common.WatchDogScreen;
import fxc.app.gui.ctrl.digital.DgtKeyboardScreen;
import fxc.app.gui.ctrl.digital.DigitalFieldController;
import fxc.app.gui.ctrl.letter.LetterFieldController;
import fxc.app.gui.ctrl.letter.LetterKeyboardScreen;
import fxc.app.gui.ctrl.ports.PortSettingController;
import fxc.app.gui.ctrl.ports.PortSettingScreen;
import fxc.app.gui.oth.CheckConnectionScreen;
import fxc.app.gui.oth.DialogScreen;
import fxc.app.gui.oth.GenerateKeyDialog;
import fxc.app.gui.oth.KeySelectScreen;
import fxc.app.gui.oth.ScanScreen;
import fxc.app.gui.oth.ServerSelectScreen;
import fxc.app.model.Environment;
import fxc.app.res.LoggerId;
import fxc.app.res.ResourceId;
import fxc.app.task.GuiTask;
import fxc.app.task.TaskExecutor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import org.apache.log4j.Logger;
import ru.softlogic.config.ConfigurationIO;
import ru.softlogic.config.add.ConSection;
import ru.softlogic.config.add.GuiConfiguration;
import ru.softlogic.config.add.GuiSection;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.lookup.HardwareLookup;
import ru.softlogic.hardware.search.ConnectedDevice;
import ru.softlogic.hardware.search.SearchResult;
import ru.softlogic.hdw.base.SerialDevConfiguration;
import ru.softlogic.hdw.dev.barcode.BarConfiguration;
import ru.softlogic.hdw.dev.barcode.BarSection;
import ru.softlogic.hdw.dev.cashacc.BvrConfiguration;
import ru.softlogic.hdw.dev.cashacc.BvrSection;
import ru.softlogic.hdw.dev.cashacc.CvrConfiguration;
import ru.softlogic.hdw.dev.cashacc.CvrSection;
import ru.softlogic.hdw.dev.cashdisp.BdmSection;
import ru.softlogic.hdw.dev.cashdisp.CdmConfiguration;
import ru.softlogic.hdw.dev.cashdisp.CdmSection;
import ru.softlogic.hdw.dev.crd.CrdConfiguration;
import ru.softlogic.hdw.dev.crd.CrdSection;
import ru.softlogic.hdw.dev.cvd.CvdConfiguration;
import ru.softlogic.hdw.dev.cvd.CvdSection;
import ru.softlogic.hdw.dev.ioc.IocConfiguration;
import ru.softlogic.hdw.dev.ioc.IocSection;
import ru.softlogic.hdw.dev.modem.ModConfiguration;
import ru.softlogic.hdw.dev.modem.ModSection;
import ru.softlogic.hdw.dev.printer.PrtConfiguration;
import ru.softlogic.hdw.dev.printer.PrtSection;
import ru.softlogic.hdw.dev.printer.pos.PosPrtConfiguration;
import ru.softlogic.hdw.dev.sensors.SnrConfiguration;
import ru.softlogic.hdw.dev.sensors.SnrSection;
import ru.softlogic.hdw.dev.watchdog.WdtConfiguration;
import ru.softlogic.hdw.dev.watchdog.WdtSection;
import ru.softlogic.hdw.dev.webcam.WcmConfiguration;
import ru.softlogic.hdw.dev.webcam.WcmSection;
import ru.softlogic.io.Port;
import ru.softlogic.io.PortScanner;
import ru.softlogic.io.PortType;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.ppp.ConnectionManager;
import ru.softlogic.ppp.ManagerFactory;

class PreloadTask
extends GuiTask {
    private final Logger log;
    private final TaskExecutor executor;
    private final LoadScreen ls;
    private final Stage stage;
    private final File home;
    private BaseApplication app;
    private StackPane stackPane;
    private ConnectionManager connectionManager;

    public PreloadTask(TaskExecutor executor, LoadScreen ls, Stage stage, File home) {
        this.executor = executor;
        this.ls = ls;
        this.stage = stage;
        this.home = home;
        this.log = LoggerId.LOG;
    }

    @Override
    protected void _onPreExecute() {
    }

    @Override
    protected void _onResult(Object object) {
        this.log.info((Object)"Start app");
        this.stage.setOnCloseRequest((EventHandler)new CloseListener(this.app));
        this.app.start();
        this.stage.setScene(new Scene((Parent)this.stackPane));
    }

    @Override
    public Object process() {
        this.log.info((Object)"Begin preload");
        this.log.info((Object)("Class path: " + System.getProperty("java.class.path")));
        this.searchPorts();
        this.searchDrivers();
        this.searchConnections();
        this.createGui();
        this.loadConfig();
        this.log.info((Object)"Preload done");
        return null;
    }

    private void searchPorts() {
        this.log.info((Object)"---- Search ports");
        String forb = System.getProperty("port.forbidden");
        this.log.info((Object)("Forbidden ports: " + forb));
        try {
            this.setProgress("load.prog.serial_ports");
            ArrayList<Object> portList = new ArrayList<Object>();
            Object[] ports = PortScanner.scanSerial();
            this.log.info((Object)("Serial ports: " + Arrays.toString(ports)));
            ports = PreloadTask.filter((String[])ports, forb);
            Environment.setSerialPorts((String[])ports);
            portList.addAll(Arrays.asList(ports));
            this.setProgress("load.prog.lpt_ports");
            ports = PortScanner.scanParallel();
            this.log.info((Object)("Parallel ports: " + Arrays.toString(ports)));
            ports = PreloadTask.filter((String[])ports, forb);
            portList.addAll(Arrays.asList(ports));
            Environment.setParallelPorts((String[])ports);
            this.setProgress("load.prog.usb_ports");
            ports = PortScanner.scanUsb();
            this.log.info((Object)("USB->LP ports: " + Arrays.toString(ports)));
            ports = PreloadTask.filter((String[])ports, forb);
            portList.addAll(Arrays.asList(ports));
            Environment.setUsbPorts((String[])ports);
        }
        catch (Throwable ex) {
            this.log.error((Object)"Error on load ports", ex);
        }
    }

    private void searchDrivers() {
        this.log.info((Object)"---- Search drivers");
        this.setProgress("load.prog.drivers");
        Set dds = HardwareLookup.lookup();
        this.log.info((Object)"Found device descriptions: ");
        for (DeviceDescription dd : dds) {
            this.log.info((Object)("    " + dd));
        }
        DeviceDescription[] ddsa = dds.toArray(new DeviceDescription[dds.size()]);
        Arrays.sort(ddsa, new DescByNameComparator());
        Environment.setDescriptions(ddsa);
    }

    private void searchConnections() {
        this.log.info((Object)"---- Search connections");
        this.setProgress("load.prog.connections");
        try {
            this.connectionManager = ManagerFactory.create();
            Object[] names = this.connectionManager.getConnectionsList();
            this.log.info((Object)("Found: " + Arrays.toString(names)));
            Environment.setConnections((String[])names);
        }
        catch (Throwable ex) {
            this.log.error((Object)"Error on search connection", ex);
        }
    }

    private void createGui() {
        this.log.info((Object)"---- Load gui");
        this.setProgress("load.prog.gui");
        HashMap<String, Screen> screens = new HashMap<String, Screen>();
        this.stackPane = new StackPane();
        Gui gui = new Gui(this.stackPane, screens);
        this.app = new BaseApplication(this.executor, this.connectionManager, gui, this.home);
        this.createScreens(screens, this.app);
        ScanScreen scanScreen = new ScanScreen();
        this.createScreen("/fxc/pane/popup/scan.fxml", scanScreen);
        gui.setScanScreen(scanScreen);
        DialogScreen dialogScreen = new DialogScreen();
        this.createScreen("/fxc/pane/popup/dialog1x.fxml", dialogScreen);
        gui.setDialog1x(dialogScreen);
        dialogScreen = new DialogScreen();
        this.createScreen("/fxc/pane/popup/dialog2x.fxml", dialogScreen);
        gui.setDialog2x(dialogScreen);
        KeySelectScreen kss = new KeySelectScreen();
        this.createScreen("/fxc/pane/popup/scankey.fxml", kss);
        gui.setKeySelectScreen(kss);
        ServerSelectScreen sss = new ServerSelectScreen();
        this.createScreen("/fxc/pane/popup/scansrv.fxml", sss);
        gui.setServerSelectScreen(sss);
        GenerateKeyDialog gkd = new GenerateKeyDialog();
        this.createScreen("/fxc/pane/popup/generate_key.fxml", gkd);
        gui.setGenerateKeyDialog(gkd);
        CheckConnectionScreen ccs = new CheckConnectionScreen(this.app);
        this.createScreen("/fxc/pane/popup/connection.fxml", ccs);
        gui.setCheckConnectionScreen(ccs);
        DgtKeyboardScreen dgtKeyboardScreen = new DgtKeyboardScreen(gui);
        this.createScreen("/fxc/pane/popup/dkeyb.fxml", dgtKeyboardScreen);
        DigitalFieldController.setListener(new DigitalFieldListenerImpl(dgtKeyboardScreen));
        HashMap<Integer, LetterKeyboardScreen> keyboards = new HashMap<Integer, LetterKeyboardScreen>();
        LetterKeyboardScreen ussdKbd = new LetterKeyboardScreen(gui);
        this.createScreen("/fxc/pane/popup/ussdkeyb.fxml", ussdKbd);
        keyboards.put(1, ussdKbd);
        LetterKeyboardScreen letKbd = new LetterKeyboardScreen(gui);
        this.createScreen("/fxc/pane/popup/lkeyb.fxml", letKbd);
        keyboards.put(0, letKbd);
        LetterFieldController.setListener(new LetterFieldListenerImpl(keyboards));
        PortSettingScreen portSettingScreen = new PortSettingScreen(gui);
        this.createScreen("/fxc/pane/popup/portsetting.fxml", portSettingScreen);
        PortSettingController.setListener(new PortSettingListenerImpl(portSettingScreen));
    }

    private void createScreens(Map<String, Screen> scs, Configurator conf) {
        this.createScreen("/fxc/pane/home.fxml", HomeScreen.class, scs, conf);
        this.createScreen("/fxc/pane/srv.fxml", SrvScreen.class, scs, conf);
        this.createScreen("/fxc/pane/billacc.fxml", BillAccScreen.class, scs, conf);
        this.createScreen("/fxc/pane/coinacc.fxml", CoinAccScreen.class, scs, conf);
        this.createScreen("/fxc/pane/billdisp.fxml", BillDispScreen.class, scs, conf);
        this.createScreen("/fxc/pane/coindisp.fxml", CoinDispScreen.class, scs, conf);
        this.createScreen("/fxc/pane/carddisp.fxml", CardDispScreen.class, scs, conf);
        this.createScreen("/fxc/pane/modem.fxml", ModemScreen.class, scs, conf);
        this.createScreen("/fxc/pane/wdt.fxml", WatchDogScreen.class, scs, conf);
        this.createScreen("/fxc/pane/gui.fxml", GuiScreen.class, scs, conf);
        this.createScreen("/fxc/pane/barcode.fxml", BarcodeScreen.class, scs, conf);
        this.createScreen("/fxc/pane/printer.fxml", PrnScreen.class, scs, conf);
        this.createScreen("/fxc/pane/sensor.fxml", SensorScreen.class, scs, conf);
        this.createScreen("/fxc/pane/ioc.fxml", IocScreen.class, scs, conf);
        this.createScreen("/fxc/pane/cardreader.fxml", CardReaderScreen.class, scs, conf);
    }

    private void createScreen(String url, Class cl, Map<String, Screen> scs, Configurator configurator) {
        try {
            FXMLLoader l = new FXMLLoader(PreloadTask.class.getResource(url), ResourceId.BUNDLE);
            Screen sc = (Screen)cl.getConstructor(Configurator.class).newInstance(configurator);
            l.setController((Object)sc);
            l.load();
            scs.put(url, sc);
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            this.log.error((Object)"Erron on create screen", (Throwable)ex);
        }
    }

    private void createScreen(String url, Object controller) {
        try {
            FXMLLoader l = new FXMLLoader(PreloadTask.class.getResource(url), ResourceId.BUNDLE);
            l.setController(controller);
            l.load();
        }
        catch (IOException ex) {
            this.log.error((Object)"Erron on create screen", (Throwable)ex);
        }
    }

    private void loadConfig() {
        this.log.info((Object)"---- Load config");
        this.setProgress("load.prog.config");
        File file = new File(this.home, "conf.xml");
        if (file.canRead()) {
            ConSection cs = new ConSection();
            BvrSection bvr = new BvrSection();
            CvrSection cvr = new CvrSection();
            BdmSection bdm = new BdmSection();
            CdmSection cdm = new CdmSection();
            CvdSection cvd = new CvdSection();
            GuiSection gui = new GuiSection();
            BarSection bar = new BarSection();
            ModSection mod = new ModSection();
            WdtSection wdt = new WdtSection();
            PrtSection prt = new PrtSection();
            SnrSection snr = new SnrSection();
            IocSection ioc = new IocSection();
            WcmSection wcm = new WcmSection();
            CrdSection crd = new CrdSection();
            LinkedList<Object> secs = new LinkedList<Object>();
            secs.add(cs);
            secs.add(bvr);
            secs.add(cvr);
            secs.add(bdm);
            secs.add(cdm);
            secs.add(cvd);
            secs.add(gui);
            secs.add(bar);
            secs.add(mod);
            secs.add(wdt);
            secs.add(prt);
            secs.add(snr);
            secs.add(ioc);
            secs.add(wcm);
            secs.add(crd);
            try {
                BvrConfiguration c;
                ConfigurationIO io = new ConfigurationIO(file, this.log);
                io.load(secs);
                this.app.setConn(cs.getConfiguration());
                LinkedList<ConnectedDevice> cds = new LinkedList<ConnectedDevice>();
                if (bvr.getConfiguration() != null) {
                    c = bvr.getConfiguration();
                    this.app.setBillAcc(c);
                    this.addConnectedDevice(cds, "bvr", (SerialDevConfiguration)c);
                }
                if (cvr.getConfiguration() != null) {
                    c = cvr.getConfiguration();
                    this.app.setCoinAcc((CvrConfiguration)c);
                    this.addConnectedDevice(cds, "cvr", (SerialDevConfiguration)c);
                }
                if (bdm.getConfiguration() != null) {
                    c = bdm.getConfiguration();
                    this.app.setBillDisp((CdmConfiguration)c);
                    this.addConnectedDevice(cds, "bdm", (SerialDevConfiguration)c);
                }
                if (cdm.getConfiguration() != null) {
                    c = cdm.getConfiguration();
                    this.app.setCoinDisp((CdmConfiguration)c);
                    this.addConnectedDevice(cds, "cdm", (SerialDevConfiguration)c);
                }
                if (cvd.getConfiguration() != null) {
                    c = cvd.getConfiguration();
                    this.app.setCardDisp((CvdConfiguration)c);
                    this.addConnectedDevice(cds, "cvd", (SerialDevConfiguration)c);
                }
                if (bar.getConfiguration() != null) {
                    c = bar.getConfiguration();
                    this.app.setBarcode((BarConfiguration)c);
                    this.addConnectedDevice(cds, "bar", (SerialDevConfiguration)c);
                }
                if (mod.getConfiguration() != null) {
                    c = mod.getConfiguration();
                    this.app.setModem((ModConfiguration)c);
                    this.addConnectedDevice(cds, "mod", (SerialDevConfiguration)c);
                }
                if (wdt.getConfiguration() != null) {
                    c = wdt.getConfiguration();
                    this.app.setWatchdog((WdtConfiguration)c);
                    this.addConnectedDevice(cds, "wdt", (SerialDevConfiguration)c);
                }
                if (prt.getConfiguration() != null) {
                    c = prt.getConfiguration();
                    this.app.setPrinter((PrtConfiguration)c);
                    this.addConnectedDevice(cds, "wdt", (PrtConfiguration)c);
                }
                if (snr.getConfiguration() != null) {
                    c = snr.getConfiguration();
                    this.app.setSensor((SnrConfiguration)c);
                    this.addConnectedDevice(cds, "snr", (SnrConfiguration)c);
                }
                if (ioc.getConfiguration() != null) {
                    c = ioc.getConfiguration();
                    this.app.setIoc((IocConfiguration)c);
                    this.addConnectedDevice(cds, "ioc", (SerialDevConfiguration)c);
                }
                if (wcm.getConfiguration() != null) {
                    c = wcm.getConfiguration();
                    this.app.setWebcam((WcmConfiguration)c);
                    this.addConnectedDevice(cds, "wcm", (SerialDevConfiguration)c);
                }
                if (crd.getConfiguration() != null) {
                    c = crd.getConfiguration();
                    this.app.setCardReader((CrdConfiguration)c);
                    this.addConnectedDevice(cds, "crd", (SerialDevConfiguration)c);
                }
                this.app.setGuiConfig(gui.getConfiguration());
                SearchResult sr = new SearchResult();
                sr.getDevices().addAll(cds);
                this.app.setSearchResult(sr);
            }
            catch (Exception ex) {
                this.log.error((Object)"Error on load conf.xml", (Throwable)ex);
            }
        } else {
            this.app.setGuiConfig(new GuiConfiguration());
            this.log.info((Object)"Config not exist");
        }
    }

    private void addConnectedDevice(List<ConnectedDevice> cds, String cat, SerialDevConfiguration sdc) {
        if (sdc.getPort() != null) {
            DeviceDescription dd = Environment.getById(cat, sdc.getType());
            if (dd != null) {
                cds.add(new ConnectedDevice(sdc.getPort(), dd));
            } else {
                this.log.error((Object)("Device description is not founs for cat=" + cat + ", type=" + sdc.getType()));
            }
        }
    }

    private void addConnectedDevice(List<ConnectedDevice> cds, String cat, PrtConfiguration c) {
        if (c != null && "pos".equals(c.getPrtClass()) && c.getPosPrtConfiguration() != null && c.getPosPrtConfiguration().getPort() != null && c.getPosPrtConfiguration().getPort().getType() == PortType.SerialPort) {
            PosPrtConfiguration ppc = c.getPosPrtConfiguration();
            DeviceDescription dd = Environment.getById(cat, ppc.getType());
            if (dd != null) {
                cds.add(new ConnectedDevice((SerialPort)ppc.getPort(), dd));
            } else {
                this.log.error((Object)("Device description is not founs for cat=" + cat + ", type=" + ppc.getType()));
            }
        }
    }

    private void addConnectedDevice(List<ConnectedDevice> cds, String cat, SnrConfiguration c) {
        if (c == null) {
            return;
        }
        Port port = c.getPort();
        if (port.getType() == PortType.SerialPort) {
            DeviceDescription dd = Environment.getById(cat, c.getDriver());
            if (dd != null) {
                cds.add(new ConnectedDevice((SerialPort)port, dd));
            } else {
                this.log.error((Object)("Device description is not founs for cat=" + cat + ", type=" + port.getType()));
            }
        }
    }

    private static String[] filter(String[] found, String forbidden) {
        if (forbidden == null || forbidden.isEmpty() || found == null || found.length == 0) {
            return found;
        }
        LinkedList<String> res = new LinkedList<String>();
        for (String f : found) {
            if (forbidden.contains(f)) continue;
            res.add(f);
        }
        return res.toArray(new String[res.size()]);
    }

    private void setProgress(String msgId) {
        Platform.runLater(() -> this.ls.setProgress(ResourceId.BUNDLE.getString(msgId)));
    }
}

