/*
 * Decompiled with CFR 0.152.
 */
package fxc;

import fxc.ApplicationException;
import fxc.Commander;
import fxc.PreloadTask;
import fxc.app.gui.common.LoadScreen;
import fxc.app.gui.oth.Dialog;
import fxc.app.gui.oth.DialogScreen;
import fxc.app.res.LoggerId;
import fxc.app.res.ResourceId;
import fxc.app.task.BaseTaskExecutor;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ConfiguratorFx
extends Application {
    private static final String LOAD_SCREEN = "/gui/configurator/load.css";
    private final Logger log;
    private Stage stage;

    public ConfiguratorFx() {
        PropertyConfigurator.configure((URL)ConfiguratorFx.class.getResource("/fxc/log4j.properties"));
        this.log = LoggerId.LOG;
    }

    public void start(Stage stage) throws Exception {
        this.stage = stage;
        this.log.info((Object)"Start app");
        this.log.info((Object)("   Java version          : " + System.getProperty("java.version")));
        this.log.info((Object)("   JavaFx version        : " + System.getProperty("javafx.runtime.version")));
        if (this.checkDuplicationInstance()) {
            FXMLLoader l = new FXMLLoader(ConfiguratorFx.class.getResource("/fxc/pane/load.fxml"), ResourceId.BUNDLE);
            Parent root = (Parent)l.load();
            File f = new File(".", LOAD_SCREEN);
            if (f.canRead()) {
                this.log.info((Object)("Load style from: " + f.getAbsolutePath()));
                try {
                    root.getStylesheets().add((Object)f.toURI().toURL().toExternalForm());
                }
                catch (MalformedURLException ex) {
                    this.log.error((Object)"Error on load style", (Throwable)ex);
                }
            } else {
                this.log.info((Object)("External style " + f.getAbsolutePath() + " is not found"));
            }
            LoadScreen ls = (LoadScreen)l.getController();
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.show();
            BaseTaskExecutor te = new BaseTaskExecutor();
            Thread th = new Thread((Runnable)te, "TaskExecutor");
            th.setDaemon(true);
            th.start();
            File home = new File(".");
            if (System.getProperty("home") != null) {
                home = new File(System.getProperty("home"));
            }
            te.add(new PreloadTask(te, ls, stage, home));
        } else {
            this.showErrorScreen();
        }
    }

    public void afterLoad() {
        this.log.info((Object)"Show main window: ");
        StackPane sp = new StackPane();
        Scene scene = new Scene((Parent)sp);
        this.stage.setScene(scene);
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> LoggerId.LOG.error((Object)("Uncaught error in thread " + t.getName()), e));
        ConfiguratorFx.launch((String[])args);
    }

    private boolean checkDuplicationInstance() {
        try {
            Commander cmd = new Commander();
            cmd.startServer();
            return true;
        }
        catch (ApplicationException ex) {
            return false;
        }
    }

    private void showErrorScreen() throws Exception {
        FXMLLoader l = new FXMLLoader(ConfiguratorFx.class.getResource("/fxc/pane/popup/error_dialog1x.fxml"), ResourceId.BUNDLE);
        DialogScreen dialogScreen = new DialogScreen();
        l.setController((Object)dialogScreen);
        Parent root = (Parent)l.load();
        Scene scene = new Scene(root);
        this.stage.setScene(scene);
        this.stage.initStyle(StageStyle.UNDECORATED);
        this.stage.show();
        this.log.error((Object)"Duplicate application's instance");
        dialogScreen.init(new Dialog(ResourceId.BUNDLE.getString("dialog.title.error"), ResourceId.BUNDLE.getString("dialog.msg.duplicate"), ResourceId.BUNDLE.getString("dialog.btn.ok")), buttonId -> System.exit(0));
    }
}

