/*
 * Decompiled with CFR 0.152.
 */
package fxc;

import fxc.ApplicationException;
import fxc.app.res.LoggerId;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ru.softlogic.system.util.ThreadUtil;

public class Commander {
    private static final String HOST = "127.0.0.1";
    private static final int PORT = 10555;
    private static final String CMD_STOP = "stop";
    private static final Logger log = LoggerId.LOG;
    private ServerSocket serverSocket;

    public void startServer() throws ApplicationException {
        try {
            this.serverSocket = new ServerSocket(10555);
            Thread th = new Thread((Runnable)new SocketListener(), "NetworkCommandListener");
            th.setDaemon(true);
            th.start();
        }
        catch (IOException ex) {
            throw new ApplicationException("Can't connect to port 10555, " + ex.getMessage());
        }
    }

    public static void shutdown() throws ApplicationException {
        try (Socket socket = new Socket(HOST, 10555);){
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8));
            bw.write("stop\n");
            bw.flush();
        }
        catch (IOException ex) {
            throw new ApplicationException(ex.getMessage());
        }
    }

    private class SocketListener
    implements Runnable {
        private SocketListener() {
        }

        @Override
        public void run() {
            log.info((Object)"Start commander thread");
            while (!Thread.currentThread().isInterrupted()) {
                log.info((Object)"Wait connection");
                try (Socket socket = Commander.this.serverSocket.accept();){
                    log.info((Object)"Connection accepted");
                    socket.setSoTimeout(10000);
                    BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
                    BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8));
                    String cmd = br.readLine();
                    if (cmd != null) {
                        if (cmd.equals(Commander.CMD_STOP)) {
                            bw.write("Stoping application");
                            log.info((Object)"Stoping application");
                        } else {
                            log.error((Object)("Received uncnown command: " + cmd));
                        }
                    } else {
                        log.error((Object)"Error on reading data");
                    }
                }
                catch (IOException ex) {
                    log.error((Object)ex);
                }
                ThreadUtil.sleep((long)1000L);
            }
            IOUtils.closeQuietly((ServerSocket)Commander.this.serverSocket);
            log.info((Object)"Stop commander thread");
        }
    }
}

