/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.installer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import ru.softlogic.installer.Logger;
import ru.softlogic.installer.apache.FileUtils;
import ru.softlogic.installer.apache.IOCase;
import ru.softlogic.installer.apache.RegexFileFilter;
import ru.softlogic.installer.apache.WildcardFileFilter;

public class Maintenance {
    public static final String ACTION_REMOVE = "rm";
    public static final String ACTION_REMOVE_UPDATE = "rmu";
    public static final String ACTION_MOVE = "mv";

    public boolean serve(File appDir, File updateDir, File rulesFile) {
        if (appDir == null) {
            throw new NullPointerException("appDir");
        }
        if (updateDir == null) {
            throw new NullPointerException("updateDir");
        }
        boolean success = true;
        Logger.info("Start software maintenance");
        try {
            List<String> lines = FileUtils.readLines(rulesFile, Charset.forName("UTF-8"));
            if (!lines.isEmpty()) {
                for (String line : lines) {
                    Logger.info("Process rule: " + line);
                    String[] rule = line.trim().replaceAll(" {2,}", " ").split(" ");
                    if (rule.length == 2 || rule.length == 3) {
                        String file;
                        String cmd = rule[0];
                        String option = rule.length == 2 ? "" : rule[1];
                        String string = file = rule.length == 2 ? rule[1] : rule[2];
                        if (file.contains("../")) {
                            Logger.info("Wrong path");
                            continue;
                        }
                        if (ACTION_REMOVE.equals(cmd)) {
                            success &= Maintenance.deleteFile(new File(appDir, file), option);
                            continue;
                        }
                        if (ACTION_REMOVE_UPDATE.equals(cmd)) {
                            success &= Maintenance.deleteFile(new File(appDir, file), option);
                            Maintenance.deleteFile(new File(updateDir, file), option);
                            continue;
                        }
                        Logger.error("Unknown action: " + rule[0] + ", skip");
                        continue;
                    }
                    Logger.info("Rule not correct");
                }
            } else {
                Logger.info("Noting to do");
            }
        }
        catch (IOException ex) {
            Logger.info("Maintenance rules not found");
        }
        return success;
    }

    private static boolean deleteFile(File file, String option) {
        if (option == null || option.isEmpty()) {
            return Maintenance.deleteFile(file);
        }
        File dir = file.getParentFile();
        String tpl = file.getName();
        if (dir.isDirectory()) {
            if ("wildcard".equals(option)) {
                return Maintenance.deleteFilesFilter(dir, new WildcardFileFilter(tpl, IOCase.INSENSITIVE));
            }
            if ("regex".equals(option)) {
                return Maintenance.deleteFilesFilter(dir, new RegexFileFilter(tpl));
            }
            Logger.info("Compatible options: wildcard, regex");
        } else {
            Logger.info("Wrong directory: " + dir.getAbsolutePath());
        }
        return false;
    }

    private static boolean deleteFilesFilter(File dir, FileFilter filter) {
        boolean success = true;
        for (File f : dir.listFiles(filter)) {
            success &= Maintenance.deleteFile(f);
        }
        return success;
    }

    private static boolean deleteFile(File file) {
        block5: {
            block3: {
                block4: {
                    Logger.debug("    Try to remove file: " + file.getAbsolutePath());
                    if (!file.exists()) break block3;
                    if (!file.delete()) break block4;
                    Logger.debug("    File deleted");
                    break block5;
                }
                Logger.error("Error on delete file, reset file & set flag 'delete on exit'");
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    FileUtils.closeQuietly(fos);
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(fos);
                    throw throwable;
                }
                FileUtils.closeQuietly(fos);
                file.deleteOnExit();
                return false;
            }
            Logger.debug("    File not exist: " + file.getAbsolutePath());
        }
        return true;
    }
}

