/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.installer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import ru.softlogic.installer.apache.FileUtils;

public class Logger {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("HH:mm:ss,SSS");
    private static final String TOKEN_INFO = "  INFO ";
    private static final String TOKEN_ERROR = " ERROR ";
    private static final String TOKEN_DEBUG = " DEBUG ";
    private static final File FILE = new File("./log/add/start.log");

    public static synchronized void info(String msg) {
        Logger.log(TOKEN_INFO, msg);
    }

    public static synchronized void debug(String msg) {
        Logger.log(TOKEN_DEBUG, msg);
    }

    public static synchronized void error(String msg) {
        Logger.log(TOKEN_ERROR, msg);
    }

    public static void error(String msg, Throwable ex) {
        Logger.log(TOKEN_ERROR, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(String token, String msg) {
        String line = SDF.format(new Date()) + token + msg + System.getProperty("line.separator");
        System.out.print(line);
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(FILE, "rw");
            raf.seek(FILE.length());
            raf.writeBytes(line);
        }
        catch (IOException ex) {
            try {
                System.out.println(line);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(raf);
                throw throwable;
            }
            FileUtils.closeQuietly(raf);
        }
        FileUtils.closeQuietly(raf);
    }

    static {
        File par = FILE.getParentFile();
        if (!par.exists()) {
            par.mkdirs();
        }
    }
}

