/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.installer;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ru.softlogic.installer.Logger;

public class InstallerFilter
implements FileFilter {
    private final Set<String> filter = new HashSet<String>();
    private boolean hasMissingFiles = false;

    public InstallerFilter(String ... names) {
        this.filter.addAll(Arrays.asList(names));
    }

    @Override
    public boolean accept(File path) {
        if (path.isDirectory()) {
            return true;
        }
        if (this.filter.contains(path.getName())) {
            Logger.info("   Skip: " + path.getAbsolutePath());
            this.hasMissingFiles = true;
            return false;
        }
        return true;
    }

    public boolean isHasMissingFiles() {
        return this.hasMissingFiles;
    }
}

