/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.installer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import ru.softlogic.installer.InstallerFilter;
import ru.softlogic.installer.Logger;
import ru.softlogic.installer.Maintenance;
import ru.softlogic.installer.apache.FileUtils;

public class Installer {
    private static final String RESULT_CODE_SUCCESS = "0";
    private static final String RESULT_CODE_ERROR = "1";
    private static final String RESULT_CODE_UNKNOWN_ERROR = "2";
    private static final String FILE_INSTALLER = "installer.jar";

    public static void main(String[] args) {
        block9: {
            File res = Installer.getFile("data/update/result.properties");
            File resDir = res.getParentFile();
            File dst = Installer.getFile("");
            File src = Installer.getFile("/update/app/");
            File mnt = Installer.getFile("/res/maintenance.rules");
            Logger.info("=== Start update ==========================================");
            Logger.info("Source      : " + src.getAbsolutePath());
            Logger.info("Destination : " + dst.getAbsolutePath());
            Logger.info("Result      : " + res.getAbsolutePath());
            Logger.info("Rules       : " + mnt.getAbsolutePath());
            if (!resDir.exists() && !resDir.mkdirs()) {
                Logger.error("Can't create result dirs");
            }
            Set<File> set = Installer.getFileSet(src);
            Logger.info("Files to update:");
            for (File f : set) {
                Logger.info("    " + f.getAbsolutePath() + ", size=" + f.length());
            }
            Logger.info("---");
            try {
                Maintenance mn = new Maintenance();
                if (!src.exists() || !src.isDirectory()) break block9;
                boolean success = true;
                String message = "Success";
                InstallerFilter filter = new InstallerFilter(FILE_INSTALLER);
                try {
                    Logger.info("Copy directory, without installer.jar");
                    FileUtils.copyDirectory(src, dst, filter);
                    Logger.info("Complete, clean " + src.getAbsolutePath() + " directory");
                    FileUtils.cleanDirectory(src, filter);
                    Logger.info("=== Maintenance software ==================================");
                    mn.serve(dst, src, mnt);
                    Logger.info("=== Update finished =======================================");
                }
                catch (IOException ex) {
                    success = false;
                    message = ex.getMessage();
                    Logger.error("An error occurred while updating: " + ex.getMessage());
                }
                Properties prop = new Properties();
                prop.put("result", success ? RESULT_CODE_SUCCESS : RESULT_CODE_ERROR);
                prop.put("message", message);
                Installer.updatePropertyFile(res, prop);
                if (filter.isHasMissingFiles() && success) {
                    try {
                        Logger.info("Move missing files");
                        FileUtils.copyDirectory(src, dst);
                        Logger.info("Clean missing files");
                        FileUtils.cleanDirectory(src);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                System.exit(success ? 0 : 1);
            }
            catch (Throwable ex) {
                Properties prop = new Properties();
                prop.put("result", RESULT_CODE_UNKNOWN_ERROR);
                prop.put("message", ex.getMessage());
                Installer.updatePropertyFile(res, prop);
                Logger.error("Unknown exception on update", ex);
            }
        }
    }

    private static File getFile(String name) {
        return new File(new File(".", name).getAbsolutePath().replace("\\.", "").replace("/.", ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updatePropertyFile(File file, Properties prop) {
        FileOutputStream fw = null;
        try {
            fw = new FileOutputStream(file);
            prop.store(new OutputStreamWriter((OutputStream)fw, "UTF-8"), null);
            Logger.info("Exit flag created");
        }
        catch (IOException ex) {
            try {
                Logger.error("Erron on create result file", ex);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fw);
                throw throwable;
            }
            FileUtils.closeQuietly(fw);
        }
        FileUtils.closeQuietly(fw);
    }

    private static Set<File> getFileSet(File srcDir) {
        TreeSet<File> res = new TreeSet<File>();
        if (srcDir.isDirectory()) {
            for (File f : srcDir.listFiles()) {
                if (f.isFile()) {
                    res.add(f);
                    continue;
                }
                if (!f.isDirectory()) continue;
                res.addAll(Installer.getFileSet(f));
            }
        }
        return res;
    }
}

