/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.generator.xsd.validator;

import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXParseException;
import ru.softlogic.generator.Options;
import ru.softlogic.schemas.XsdValidator;

public class LocalXsdValidator {
    public static AbstractMap.SimpleEntry<String, List<SAXParseException>> validate(File xmlFile, Options options) {
        List<SAXParseException> exceptions = new ArrayList<SAXParseException>();
        boolean isForm = false;
        try {
            String root = XsdValidator.getRootElement((File)xmlFile);
            if ("forms".equals(root)) {
                isForm = true;
                if (options.getFormCheck() == Options.DISABLE) {
                    return new AbstractMap.SimpleEntry<String, List<SAXParseException>>("forms", exceptions);
                }
            } else if ("scenario".equals(root)) {
                if (options.getScenarioCheck() == Options.DISABLE) {
                    return new AbstractMap.SimpleEntry<String, List<SAXParseException>>("scenario", exceptions);
                }
            } else {
                return new AbstractMap.SimpleEntry<String, List<SAXParseException>>("forms", exceptions);
            }
            exceptions = isForm && !options.isFormNamespace() || !isForm && !options.isScenarioNamespace() ? XsdValidator.validateXml((File)xmlFile, (boolean)false) : XsdValidator.validateXml((File)xmlFile, (boolean)true);
        }
        catch (Exception ex) {
            exceptions.add(new SAXParseException(ex.getMessage(), null));
        }
        return new AbstractMap.SimpleEntry<String, List<SAXParseException>>(isForm ? "forms" : "scenario", exceptions);
    }
}

