/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.generator;

import java.io.File;
import java.io.FileFilter;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.SAXParseException;
import ru.softlogic.generator.Options;
import ru.softlogic.generator.Utils;
import ru.softlogic.generator.walker.BaseFileFilter;
import ru.softlogic.generator.walker.Visitor;
import ru.softlogic.generator.xsd.validator.LocalXsdValidator;

public class ValidateVisitor
implements Visitor {
    private final List<String> wrongCharErrors = new LinkedList<String>();
    private final List<String> wrongCaseErrors = new LinkedList<String>();
    private final List<String> xmlFormsErrors = new LinkedList<String>();
    private final List<String> xmlScenarioErrors = new LinkedList<String>();
    private final Options options;
    private final FileFilter fileFilter;

    public ValidateVisitor(File root, Options options) {
        this.fileFilter = new BaseFileFilter(root, options.getExcludeCheck());
        this.options = options;
    }

    @Override
    public void onFile(File file) {
        String path = Utils.getRelativePath(file);
        if (!path.matches("^[0-9a-zA-Z\\\\./_-]+$")) {
            this.wrongCharErrors.add(path);
        }
        if (path.matches(".*[A-Z]+.*")) {
            this.wrongCaseErrors.add(path);
        }
        if (path.endsWith("xml")) {
            this.validateXml(file, path);
        }
    }

    private void validateXml(File file, String path) {
        AbstractMap.SimpleEntry<String, List<SAXParseException>> retult = LocalXsdValidator.validate(file, this.options);
        List<SAXParseException> exceptionsList = retult.getValue();
        if (!exceptionsList.isEmpty()) {
            int skipped = 0;
            StringBuilder sb = new StringBuilder("File: ");
            sb.append(path).append("\n");
            for (int i = 0; i < exceptionsList.size(); ++i) {
                SAXParseException spe = exceptionsList.get(i);
                if (i > 0) {
                    SAXParseException last = exceptionsList.get(i - 1);
                    if (spe.getLineNumber() == last.getLineNumber() && spe.getColumnNumber() == last.getColumnNumber()) {
                        ++skipped;
                        continue;
                    }
                }
                sb.append(spe.getLineNumber()).append(":");
                sb.append(spe.getColumnNumber()).append("   ");
                sb.append(spe.getMessage().replaceAll("(\\s){2,}", " ")).append('\n');
            }
            sb.append("Number of errors: ").append(exceptionsList.size() - skipped).append("\n");
            if ("forms".equals(retult.getKey())) {
                this.xmlFormsErrors.add(sb.toString());
            } else if ("scenario".equals(retult.getKey())) {
                this.xmlScenarioErrors.add(sb.toString());
            }
        }
    }

    public List<String> getWrongCharErrors() {
        return this.wrongCharErrors;
    }

    public List<String> getWrongCaseErrors() {
        return this.wrongCaseErrors;
    }

    public List<String> getFormsErrors() {
        return this.xmlFormsErrors;
    }

    public List<String> getScenarioErrors() {
        return this.xmlScenarioErrors;
    }

    public boolean hasErrors() {
        return this.getTotalErrors() > 0;
    }

    public int getTotalErrors() {
        int scenErr = this.options.getScenarioCheck() == Options.VALIDATE_ONLY ? 0 : this.xmlScenarioErrors.size();
        int formErr = this.options.getFormCheck() == Options.VALIDATE_ONLY ? 0 : this.xmlFormsErrors.size();
        return this.wrongCaseErrors.size() + this.wrongCharErrors.size() + scenErr + formErr;
    }

    @Override
    public FileFilter getFilter() {
        return this.fileFilter;
    }
}

