/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import ru.softlogic.generator.Options;

public class OptionsParser {
    private static final String FORM_CHECK = "form.check";
    private static final String FORM_NAMESPACE = "form.namespace";
    private static final String SCEN_CHECK = "scenario.check";
    private static final String SCEN_NAMESPACE = "scenario.namespace";
    private static final String PATHS_EXCLUDE_CHECK = "paths.check.exclude";
    private static final String PATHS_EXCLUDE_GEN = "paths.generate.exclude";

    public static Options parse(File file) {
        Properties prop = OptionsParser.loadProperties(file);
        if (prop == null) {
            prop = OptionsParser.loadDefaultProperties();
        }
        int formCheck = OptionsParser.parseCheckProperty(prop, FORM_CHECK);
        boolean formNamespace = "required".equals(prop.getProperty(FORM_NAMESPACE));
        int scenarioCheck = OptionsParser.parseCheckProperty(prop, SCEN_CHECK);
        boolean scenarioNamespace = "required".equals(prop.getProperty(SCEN_NAMESPACE));
        List<String> excludeCheck = OptionsParser.parseExcludePath(prop, PATHS_EXCLUDE_CHECK);
        List<String> excludeValidate = OptionsParser.parseExcludePath(prop, PATHS_EXCLUDE_GEN);
        return new Options(formCheck, formNamespace, scenarioCheck, scenarioNamespace, excludeCheck, excludeValidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadDefaultProperties() {
        Properties prop = new Properties();
        InputStream in = null;
        try {
            in = OptionsParser.class.getResourceAsStream("options.properties");
            prop.load(in);
        }
        catch (IOException ex) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {}
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(File file) {
        InputStream in = null;
        try {
            Properties prop = new Properties();
            in = new FileInputStream(file);
            prop.load(in);
            Properties properties = prop;
            return properties;
        }
        catch (IOException ex) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {}
        }
        return null;
    }

    private static int parseCheckProperty(Properties prop, String name) {
        String checkForm = prop.getProperty(name);
        if ("validate-only".equals(checkForm)) {
            return Options.VALIDATE_ONLY;
        }
        if ("enable".equals(checkForm)) {
            return Options.ENABLE;
        }
        return Options.DISABLE;
    }

    private static List<String> parseExcludePath(Properties prop, String name) {
        ArrayList<String> list = new ArrayList<String>();
        String exclude = prop.getProperty(name);
        if (exclude != null) {
            String[] paths;
            for (String path : paths = exclude.split(",")) {
                String value = path.trim();
                if (value.isEmpty()) continue;
                list.add(value);
            }
        }
        return list;
    }
}

