/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.generator;

import java.io.File;
import java.io.FileFilter;
import java.util.List;
import ru.softlogic.generator.Utils;
import ru.softlogic.generator.walker.BaseFileFilter;
import ru.softlogic.generator.walker.Visitor;

public class GenerateVisitor
implements Visitor {
    private final StringBuilder sb = new StringBuilder("<root>\n");
    private final FileFilter fileFilter;
    private String result;

    public GenerateVisitor(File file, List<String> exclude) {
        this.fileFilter = new BaseFileFilter(file, exclude);
    }

    @Override
    public void onFile(File file) {
        this.sb.append("<file name=\"").append(Utils.getRelativePath(file)).append("\" crc=\"").append(Utils.calculateChecksum(file)).append("\" size=\"").append(file.length()).append("\" mtime=\"").append(file.lastModified()).append("\"/>\n");
    }

    public String getResult() {
        if (this.result == null) {
            this.result = this.sb.append("</root>").toString();
        }
        return this.result;
    }

    @Override
    public FileFilter getFilter() {
        return this.fileFilter;
    }
}

