/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.dtd.models.CMStateSet;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSElementDeclHelper;
import org.apache.xerces.impl.xs.XSOpenContentDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.models.XS11AllCM;
import org.apache.xerces.impl.xs.models.XS11CMRestriction;
import org.apache.xerces.impl.xs.models.XSCMBinOp;
import org.apache.xerces.impl.xs.models.XSCMLeaf;
import org.apache.xerces.impl.xs.models.XSCMRepeatingLeaf;
import org.apache.xerces.impl.xs.models.XSCMUniOp;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.XSTerm;

public class XSDFACM
implements XSCMValidator,
XS11CMRestriction.XS11CM {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private XSElementDecl[] fElements;
    private XSWildcardDecl[] fWildcards;
    private int fNumElements;
    private int fNumTotal;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private XSCMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private int[][] fTransTable = null;
    private final XSOpenContentDecl fOpenContent;
    private final short fSchemaVersion;
    private Occurence[] fCountingStates = null;
    private int fTransTableSize = 0;
    private boolean fIsCompactedForUPA;
    private static long time = 0L;

    public XSDFACM(CMNode cMNode, int n, short s, XSOpenContentDecl xSOpenContentDecl) {
        this.fLeafCount = n;
        this.fIsCompactedForUPA = cMNode.isCompactedForUPA();
        this.fSchemaVersion = s;
        this.fOpenContent = xSOpenContentDecl;
        this.buildDFA(cMNode);
    }

    public boolean isFinalState(int n) {
        return n < 0 ? false : this.fFinalStateFlags[n];
    }

    public Object oneTransition(QName qName, int[] nArray, SubstitutionGroupHandler substitutionGroupHandler, XSElementDeclHelper xSElementDeclHelper) {
        Object object = this.oneTransition1(qName, nArray, substitutionGroupHandler, xSElementDeclHelper);
        if (this.fOpenContent != null && object == this.fOpenContent.fWildcard) {
            object = this.fOpenContent;
        }
        return object;
    }

    private Object oneTransition1(QName qName, int[] nArray, SubstitutionGroupHandler substitutionGroupHandler, XSElementDeclHelper xSElementDeclHelper) {
        int n;
        int n2 = nArray[0];
        if (n2 == -1 || n2 == -2) {
            if (n2 == -1) {
                nArray[0] = -2;
            }
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        int n3 = 0;
        XSTerm xSTerm = null;
        for (n = 0; n < this.fNumElements && ((n3 = this.fTransTable[n2][n]) == -1 || (xSTerm = substitutionGroupHandler.getMatchingElemDecl(qName, this.fElements[n], this.fSchemaVersion)) == null); ++n) {
        }
        if (xSTerm == null) {
            while (n < this.fNumTotal) {
                n3 = this.fTransTable[n2][n];
                if (n3 != -1) {
                    if (this.fSchemaVersion < 4) {
                        if (this.fWildcards[n].allowNamespace(qName.uri)) {
                            xSTerm = this.fWildcards[n];
                            break;
                        }
                    } else if (this.allowExpandedName(this.fWildcards[n], qName, substitutionGroupHandler, xSElementDeclHelper)) {
                        xSTerm = this.fWildcards[n];
                        break;
                    }
                }
                ++n;
            }
        }
        if (xSTerm == null) {
            nArray[1] = nArray[0];
            nArray[0] = -1;
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        nArray[0] = n3;
        if (this.fCountingStates == null) {
            return xSTerm;
        }
        if (this.fOpenContent != null && this.fOpenContent.fWildcard == xSTerm && this.fOpenContent.fMode == 1) {
            return xSTerm;
        }
        Occurence occurence = this.fCountingStates[n2];
        if (occurence != null) {
            if (n2 == n3) {
                nArray[2] = nArray[2] + 1;
                if (nArray[2] > occurence.maxOccurs && occurence.maxOccurs != -1) {
                    return this.findMatchingDecl(qName, nArray, substitutionGroupHandler, n, xSElementDeclHelper);
                }
            } else {
                if (nArray[2] < occurence.minOccurs) {
                    nArray[1] = nArray[0];
                    nArray[0] = -1;
                    return this.findMatchingDecl(qName, substitutionGroupHandler);
                }
                occurence = this.fCountingStates[n3];
                if (occurence != null) {
                    nArray[2] = n == occurence.elemIndex ? 1 : 0;
                }
            }
        } else {
            occurence = this.fCountingStates[n3];
            if (occurence != null) {
                nArray[2] = n == occurence.elemIndex ? 1 : 0;
            }
        }
        return xSTerm;
    }

    Object findMatchingDecl(QName qName, SubstitutionGroupHandler substitutionGroupHandler) {
        int n;
        XSElementDecl xSElementDecl = null;
        for (n = 0; n < this.fNumElements; ++n) {
            xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fElements[n], this.fSchemaVersion);
            if (xSElementDecl == null) continue;
            return xSElementDecl;
        }
        for (n = this.fNumElements; n < this.fNumTotal; ++n) {
            if (!this.fWildcards[n].allowQName(qName)) continue;
            return this.fWildcards[n];
        }
        return null;
    }

    Object findMatchingDecl(QName qName, int[] nArray, SubstitutionGroupHandler substitutionGroupHandler, int n, XSElementDeclHelper xSElementDeclHelper) {
        int n2 = nArray[0];
        int n3 = 0;
        XSTerm xSTerm = null;
        while (n < this.fNumElements && ((n3 = this.fTransTable[n2][n]) == -1 || (xSTerm = substitutionGroupHandler.getMatchingElemDecl(qName, this.fElements[n], this.fSchemaVersion)) == null)) {
            ++n;
        }
        if (xSTerm == null) {
            while (n < this.fNumTotal) {
                if (this.fSchemaVersion < 4) {
                    if (this.fWildcards[n].allowNamespace(qName.uri)) {
                        xSTerm = this.fWildcards[n];
                        break;
                    }
                } else if (this.allowExpandedName(this.fWildcards[n], qName, substitutionGroupHandler, xSElementDeclHelper)) {
                    xSTerm = this.fWildcards[n];
                    break;
                }
                ++n;
            }
        }
        if (xSTerm == null) {
            nArray[1] = nArray[0];
            nArray[0] = -1;
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        nArray[0] = n3;
        Occurence occurence = this.fCountingStates[n3];
        if (occurence != null) {
            nArray[2] = n == occurence.elemIndex ? 1 : 0;
        }
        return xSTerm;
    }

    XSElementDecl findMatchingElemDecl(QName qName, SubstitutionGroupHandler substitutionGroupHandler) {
        XSElementDecl xSElementDecl = null;
        for (int i = 0; i < this.fNumElements; ++i) {
            xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fElements[i], this.fSchemaVersion);
            if (xSElementDecl == null) continue;
            return xSElementDecl;
        }
        return null;
    }

    public boolean allowExpandedName(XSWildcardDecl xSWildcardDecl, QName qName, SubstitutionGroupHandler substitutionGroupHandler, XSElementDeclHelper xSElementDeclHelper) {
        if (xSWildcardDecl.allowQName(qName)) {
            if (xSWildcardDecl.fDisallowedSibling && this.findMatchingElemDecl(qName, substitutionGroupHandler) != null) {
                return false;
            }
            return !xSWildcardDecl.fDisallowedDefined || xSElementDeclHelper.getGlobalElementDecl(qName) == null;
        }
        return false;
    }

    public int[] startContentModel() {
        return new int[3];
    }

    public boolean endContentModel(int[] nArray) {
        int n = nArray[0];
        if (this.fFinalStateFlags[n]) {
            Occurence occurence;
            return this.fCountingStates == null || (occurence = this.fCountingStates[n]) == null || nArray[2] >= occurence.minOccurs;
        }
        return false;
    }

    private void buildDFA(CMNode cMNode) {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        int n5;
        int n6 = this.fLeafCount;
        XSCMLeaf xSCMLeaf = new XSCMLeaf(1, null, -1, this.fLeafCount++);
        this.fHeadNode = new XSCMBinOp(102, cMNode, xSCMLeaf);
        this.fLeafList = new XSCMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        for (int i = 0; i < this.fLeafCount; ++i) {
            this.fFollowList[i] = new CMStateSet(this.fLeafCount);
        }
        this.calcFollowList(this.fHeadNode);
        Object[] objectArray = new Object[this.fLeafCount];
        int[] nArray = new int[this.fLeafCount];
        int[] nArray2 = new int[this.fLeafCount];
        int n7 = 0;
        Occurence[] occurenceArray = null;
        int n8 = 0;
        for (n5 = 0; n5 < this.fLeafCount; ++n5) {
            objectArray[n5] = null;
            int n9 = this.fLeafList[n5].getParticleId();
            for (n4 = 0; n4 < n7 && n9 != nArray2[n4]; ++n4) {
            }
            if (n4 != n7) continue;
            XSCMLeaf xSCMLeaf2 = this.fLeafList[n5];
            objectArray[n7] = xSCMLeaf2.getLeaf();
            if (xSCMLeaf2 instanceof XSCMRepeatingLeaf) {
                if (occurenceArray == null) {
                    occurenceArray = new Occurence[this.fLeafCount];
                }
                occurenceArray[n7] = new Occurence((XSCMRepeatingLeaf)xSCMLeaf2, n7);
            }
            nArray[n7] = this.fLeafListType[n5];
            nArray2[n7] = n9;
            if (nArray[n7] == 1) {
                ++n8;
            }
            ++n7;
        }
        --n8;
        this.fNumTotal = --n7;
        if (this.fOpenContent != null) {
            ++this.fNumTotal;
        }
        n5 = 0;
        n4 = n7 - 1;
        while (true) {
            if (n5 <= n4 && nArray[n5] == 1) {
                ++n5;
                continue;
            }
            while (n4 >= n5 && nArray[n4] == 2) {
                --n4;
            }
            if (n5 >= n4) break;
            Object object2 = objectArray[n5];
            objectArray[n5] = objectArray[n4];
            objectArray[n4] = object2;
            int n10 = nArray2[n5];
            nArray2[n5] = nArray2[n4];
            nArray2[n4] = n10;
            if (occurenceArray != null) {
                Occurence occurence = occurenceArray[n5];
                occurenceArray[n5] = occurenceArray[n4];
                occurenceArray[n4] = occurence;
                if (occurenceArray[n5] != null) {
                    occurenceArray[n5].elemIndex = n5;
                }
                if (occurenceArray[n4] != null) {
                    occurenceArray[n4].elemIndex = n4;
                }
            }
            ++n5;
            --n4;
        }
        int[] nArray3 = new int[this.fLeafCount + n7];
        n4 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            int n11 = nArray2[n3];
            for (int i = 0; i < this.fLeafCount; ++i) {
                if (n11 != this.fLeafList[i].getParticleId()) continue;
                nArray3[n4++] = i;
            }
            nArray3[n4++] = -1;
        }
        n3 = this.fLeafCount * 4;
        CMStateSet[] cMStateSetArray = new CMStateSet[n3];
        this.fFinalStateFlags = new boolean[n3];
        this.fTransTable = new int[n3][];
        CMStateSet cMStateSet = this.fHeadNode.firstPos();
        int n12 = 0;
        int n13 = 0;
        this.fTransTable[n13] = this.makeDefStateList();
        cMStateSetArray[n13] = cMStateSet;
        ++n13;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        while (n12 < n13) {
            cMStateSet = cMStateSetArray[n12];
            int[] nArray4 = this.fTransTable[n12];
            this.fFinalStateFlags[n12] = cMStateSet.getBit(n6);
            ++n12;
            object = null;
            n2 = 0;
            for (int i = 0; i < n7; ++i) {
                int n14;
                if (object == null) {
                    object = new CMStateSet(this.fLeafCount);
                } else {
                    ((CMStateSet)object).zeroBits();
                }
                int n15 = nArray3[n2++];
                while (n15 != -1) {
                    if (cMStateSet.getBit(n15)) {
                        ((CMStateSet)object).union(this.fFollowList[n15]);
                    }
                    n15 = nArray3[n2++];
                }
                if (((CMStateSet)object).isEmpty()) continue;
                Integer n16 = (Integer)hashMap.get(object);
                int n17 = n14 = n16 == null ? n13 : n16;
                if (n14 == n13) {
                    cMStateSetArray[n13] = object;
                    this.fTransTable[n13] = this.makeDefStateList();
                    hashMap.put(object, new Integer(n13));
                    ++n13;
                    object = null;
                }
                nArray4[i] = n14;
                if (n13 != n3) continue;
                int n18 = (int)((double)n3 * 1.5);
                CMStateSet[] cMStateSetArray2 = new CMStateSet[n18];
                boolean[] blArray = new boolean[n18];
                int[][] nArrayArray = new int[n18][];
                System.arraycopy(cMStateSetArray, 0, cMStateSetArray2, 0, n3);
                System.arraycopy(this.fFinalStateFlags, 0, blArray, 0, n3);
                System.arraycopy(this.fTransTable, 0, nArrayArray, 0, n3);
                n3 = n18;
                cMStateSetArray = cMStateSetArray2;
                this.fFinalStateFlags = blArray;
                this.fTransTable = nArrayArray;
            }
        }
        if (occurenceArray != null) {
            this.fCountingStates = new Occurence[n13];
            block10: for (int i = 0; i < n13; ++i) {
                object = this.fTransTable[i];
                for (n2 = 0; n2 < ((int[])object).length; ++n2) {
                    if (i != object[n2]) continue;
                    this.fCountingStates[i] = occurenceArray[n2];
                    continue block10;
                }
            }
        }
        this.fTransTableSize = n13;
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
        this.fLeafListType = null;
        nArray2 = null;
        if (this.fOpenContent != null) {
            int n19;
            objectArray[n7] = this.fOpenContent.fWildcard;
            if (this.fOpenContent.fMode == 1) {
                for (n19 = 0; n19 < this.fTransTableSize; ++n19) {
                    this.fTransTable[n19][n7] = n19;
                }
            } else {
                for (n19 = 0; n19 < this.fTransTableSize; ++n19) {
                    if (!this.fFinalStateFlags[n19]) continue;
                    this.fTransTable[n19][n7] = this.fTransTableSize;
                }
                this.fTransTable[this.fTransTableSize] = this.makeDefStateList();
                this.fTransTable[this.fTransTableSize][n7] = this.fTransTableSize;
                this.fFinalStateFlags[this.fTransTableSize] = true;
                ++this.fTransTableSize;
            }
            ++n7;
        }
        this.fNumElements = n8;
        if (n8 > 0) {
            this.fElements = new XSElementDecl[n8];
        }
        if (this.fNumTotal > n8) {
            this.fWildcards = new XSWildcardDecl[this.fNumTotal];
        }
        for (n = 0; n < n8; ++n) {
            this.fElements[n] = (XSElementDecl)objectArray[n];
        }
        for (n = n8; n < this.fNumTotal; ++n) {
            this.fWildcards[n] = (XSWildcardDecl)objectArray[n];
        }
    }

    private void calcFollowList(CMNode cMNode) {
        if (cMNode.type() == 101) {
            this.calcFollowList(((XSCMBinOp)cMNode).getLeft());
            this.calcFollowList(((XSCMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 102) {
            this.calcFollowList(((XSCMBinOp)cMNode).getLeft());
            this.calcFollowList(((XSCMBinOp)cMNode).getRight());
            CMStateSet cMStateSet = ((XSCMBinOp)cMNode).getLeft().lastPos();
            CMStateSet cMStateSet2 = ((XSCMBinOp)cMNode).getRight().firstPos();
            for (int i = 0; i < this.fLeafCount; ++i) {
                if (!cMStateSet.getBit(i)) continue;
                this.fFollowList[i].union(cMStateSet2);
            }
        } else if (cMNode.type() == 4 || cMNode.type() == 6) {
            this.calcFollowList(((XSCMUniOp)cMNode).getChild());
            CMStateSet cMStateSet = cMNode.firstPos();
            CMStateSet cMStateSet3 = cMNode.lastPos();
            for (int i = 0; i < this.fLeafCount; ++i) {
                if (!cMStateSet3.getBit(i)) continue;
                this.fFollowList[i].union(cMStateSet);
            }
        } else if (cMNode.type() == 5) {
            this.calcFollowList(((XSCMUniOp)cMNode).getChild());
        }
    }

    private void dumpTree(CMNode cMNode, int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            System.out.print("   ");
        }
        n2 = cMNode.type();
        switch (n2) {
            case 101: 
            case 102: {
                if (n2 == 101) {
                    System.out.print("Choice Node ");
                } else {
                    System.out.print("Seq Node ");
                }
                if (cMNode.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                this.dumpTree(((XSCMBinOp)cMNode).getLeft(), n + 1);
                this.dumpTree(((XSCMBinOp)cMNode).getRight(), n + 1);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                System.out.print("Rep Node ");
                if (cMNode.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                this.dumpTree(((XSCMUniOp)cMNode).getChild(), n + 1);
                break;
            }
            case 1: {
                System.out.print("Leaf: (pos=" + ((XSCMLeaf)cMNode).getPosition() + "), " + "(elemIndex=" + ((XSCMLeaf)cMNode).getLeaf() + ") ");
                if (cMNode.isNullable()) {
                    System.out.print(" Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                break;
            }
            case 2: {
                System.out.print("Any Node: ");
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                break;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_NIICM");
            }
        }
    }

    private int[] makeDefStateList() {
        int[] nArray = new int[this.fNumTotal];
        for (int i = 0; i < this.fNumTotal; ++i) {
            nArray[i] = -1;
        }
        return nArray;
    }

    private void postTreeBuildInit(CMNode cMNode) throws RuntimeException {
        cMNode.setMaxStates(this.fLeafCount);
        XSCMLeaf xSCMLeaf = null;
        int n = 0;
        if (cMNode.type() == 2) {
            xSCMLeaf = (XSCMLeaf)cMNode;
            n = xSCMLeaf.getPosition();
            this.fLeafList[n] = xSCMLeaf;
            this.fLeafListType[n] = 2;
        } else if (cMNode.type() == 101 || cMNode.type() == 102) {
            this.postTreeBuildInit(((XSCMBinOp)cMNode).getLeft());
            this.postTreeBuildInit(((XSCMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 4 || cMNode.type() == 6 || cMNode.type() == 5) {
            this.postTreeBuildInit(((XSCMUniOp)cMNode).getChild());
        } else if (cMNode.type() == 1) {
            xSCMLeaf = (XSCMLeaf)cMNode;
            n = xSCMLeaf.getPosition();
            this.fLeafList[n] = xSCMLeaf;
            this.fLeafListType[n] = 1;
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM");
        }
    }

    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler substitutionGroupHandler, XSConstraints xSConstraints) throws XMLSchemaException {
        int n;
        int n2;
        int n3 = this.fOpenContent != null ? this.fNumTotal - 1 : this.fNumTotal;
        byte[][] byArray = new byte[n3][n3];
        for (n2 = 0; n2 < this.fTransTableSize; ++n2) {
            for (n = 0; n < n3; ++n) {
                for (int i = n + 1; i < n3; ++i) {
                    if (this.fTransTable[n2][n] == -1 || this.fTransTable[n2][i] == -1 || byArray[n][i] != 0) continue;
                    if (xSConstraints.overlapUPA(n < this.fNumElements ? this.fElements[n] : this.fWildcards[n], i < this.fNumElements ? this.fElements[i] : this.fWildcards[i], substitutionGroupHandler)) {
                        Occurence occurence;
                        if (this.fCountingStates != null && (occurence = this.fCountingStates[n2]) != null && this.fTransTable[n2][n] == n2 ^ this.fTransTable[n2][i] == n2 && occurence.minOccurs == occurence.maxOccurs) {
                            byArray[n][i] = -1;
                            continue;
                        }
                        byArray[n][i] = 1;
                        continue;
                    }
                    byArray[n][i] = -1;
                }
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                if (byArray[n2][n] != 1) continue;
                throw new XMLSchemaException("cos-nonambig", new Object[]{n2 < this.fNumElements ? this.fElements[n2] : this.fWildcards[n2], n < this.fNumElements ? this.fElements[n] : this.fWildcards[n]});
            }
        }
        for (n2 = this.fNumElements; n2 < n3; ++n2) {
            XSWildcardDecl xSWildcardDecl = this.fWildcards[n2];
            if (xSWildcardDecl.fType != 3 && xSWildcardDecl.fType != 2) continue;
            return true;
        }
        return false;
    }

    public Vector whatCanGoHere(int[] nArray) {
        int n = this.fOpenContent != null ? this.fNumTotal - 1 : this.fNumTotal;
        int n2 = nArray[0];
        if (n2 < 0) {
            n2 = nArray[1];
        }
        Occurence occurence = this.fCountingStates != null ? this.fCountingStates[n2] : null;
        int n3 = nArray[2];
        Vector<XSElementDecl> vector = new Vector<XSElementDecl>();
        for (int i = 0; i < n; ++i) {
            int n4 = this.fTransTable[n2][i];
            if (n4 == -1 || occurence != null && (n2 != n4 ? n3 < occurence.minOccurs : n3 >= occurence.maxOccurs && occurence.maxOccurs != -1)) continue;
            vector.addElement((XSElementDecl)(i < this.fNumElements ? this.fElements[i] : this.fWildcards[i]));
        }
        return vector;
    }

    public int[] occurenceInfo(int[] nArray) {
        if (this.fCountingStates != null) {
            Occurence occurence;
            int n = nArray[0];
            if (n < 0) {
                n = nArray[1];
            }
            if ((occurence = this.fCountingStates[n]) != null) {
                int[] nArray2 = new int[]{occurence.minOccurs, occurence.maxOccurs, nArray[2], occurence.elemIndex};
                return nArray2;
            }
        }
        return null;
    }

    public String getTermName(int n) {
        XSTerm xSTerm = n < this.fNumElements ? this.fElements[n] : this.fWildcards[n];
        return xSTerm != null ? xSTerm.toString() : null;
    }

    public boolean isCompactedForUPA() {
        return this.fIsCompactedForUPA;
    }

    public XSElementDecl nextElementTransition(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = nArray3[0] + 1; i < this.fNumElements; ++i) {
            if (!this.isAllowedTransition(nArray, nArray2, i)) continue;
            nArray3[0] = i;
            return this.fElements[i];
        }
        nArray3[0] = -1;
        return null;
    }

    public XSWildcardDecl nextWildcardTransition(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int n2 = n = nArray3[0] == -1 ? this.fNumElements : nArray3[0] + 1;
        while (n < this.fNumTotal) {
            if (this.isAllowedTransition(nArray, nArray2, n)) {
                nArray3[0] = n;
                return this.fWildcards[n];
            }
            ++n;
        }
        nArray3[0] = -1;
        return null;
    }

    private boolean isAllowedTransition(int[] nArray, int[] nArray2, int n) {
        int n2 = this.fTransTable[nArray[0]][n];
        if (n2 == -1) {
            return false;
        }
        if (nArray2 != null) {
            nArray2[0] = n2;
        }
        if (this.fCountingStates == null) {
            return true;
        }
        if (n == this.fNumTotal - 1 && this.fOpenContent != null && this.fOpenContent.fMode == 1) {
            return true;
        }
        Occurence occurence = this.fCountingStates[nArray[0]];
        if (occurence != null) {
            if (nArray[0] == n2) {
                if (nArray[2] == occurence.maxOccurs) {
                    return false;
                }
                if (nArray2 != null) {
                    nArray2[2] = nArray[2];
                    if (nArray2[2] == 0 || nArray2[2] < occurence.minOccurs || occurence.maxOccurs != -1) {
                        nArray2[2] = nArray2[2] + 1;
                    }
                }
            } else {
                if (nArray[2] < occurence.minOccurs) {
                    return false;
                }
                occurence = this.fCountingStates[n2];
                if (occurence != null && nArray2 != null) {
                    nArray2[2] = n == occurence.elemIndex ? 1 : 0;
                }
            }
        } else {
            occurence = this.fCountingStates[n2];
            if (occurence != null && nArray2 != null) {
                nArray2[2] = n == occurence.elemIndex ? 1 : 0;
            }
        }
        return true;
    }

    public boolean isOpenContent(XSWildcardDecl xSWildcardDecl) {
        return this.fOpenContent != null && this.fOpenContent.fWildcard == xSWildcardDecl;
    }

    public List getDefinedNames(SubstitutionGroupHandler substitutionGroupHandler) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.fNumElements; ++i) {
            XSElementDecl xSElementDecl = this.fElements[i];
            arrayList.add(xSElementDecl.fTargetNamespace);
            arrayList.add(xSElementDecl.fName);
            if (xSElementDecl.fScope != 1) continue;
            XSElementDecl[] xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl, this.fSchemaVersion);
            for (int j = 0; j < xSElementDeclArray.length; ++j) {
                arrayList.add(xSElementDeclArray[j].fTargetNamespace);
                arrayList.add(xSElementDeclArray[j].fName);
            }
        }
        return arrayList;
    }

    public void optimizeStates(XS11CMRestriction.XS11CM xS11CM, int[] nArray, int[] nArray2, int n) {
        if (this.fCountingStates == null || this.fCountingStates[nArray2[0]] == null) {
            return;
        }
        if (nArray2[2] <= 0) {
            return;
        }
        int n2 = 0;
        if (nArray2[2] < this.fCountingStates[nArray2[0]].minOccurs) {
            n2 = this.fCountingStates[nArray2[0]].minOccurs - nArray2[2];
        } else if (nArray2[2] > this.fCountingStates[nArray2[0]].minOccurs && nArray2[2] < this.fCountingStates[nArray2[0]].maxOccurs) {
            n2 = this.fCountingStates[nArray2[0]].maxOccurs - nArray2[2];
        }
        if (n2 == 0) {
            return;
        }
        if (xS11CM instanceof XSDFACM) {
            this.optimizeForDFABase((XSDFACM)xS11CM, nArray, nArray2, n2);
        } else if (xS11CM instanceof XS11AllCM) {
            this.optimizeForAllBase((XS11AllCM)xS11CM, nArray, nArray2, n2, n);
        }
    }

    private void optimizeForDFABase(XSDFACM xSDFACM, int[] nArray, int[] nArray2, int n) {
        if (xSDFACM.fCountingStates == null || xSDFACM.fCountingStates[nArray[0]] == null) {
            return;
        }
        if (nArray[2] <= 0) {
            return;
        }
        if (xSDFACM.fCountingStates[nArray2[0]].maxOccurs == -1) {
            nArray2[2] = nArray2[2] + n;
            nArray[2] = nArray[2] + n > xSDFACM.fCountingStates[nArray2[0]].minOccurs ? xSDFACM.fCountingStates[nArray2[0]].minOccurs : nArray[2] + n;
        } else {
            if (n > xSDFACM.fCountingStates[nArray2[0]].maxOccurs - nArray[2]) {
                n = xSDFACM.fCountingStates[nArray2[0]].maxOccurs - nArray[2];
            }
            nArray[2] = nArray[2] + n;
            nArray2[2] = nArray2[2] + n;
        }
    }

    private void optimizeForAllBase(XS11AllCM xS11AllCM, int[] nArray, int[] nArray2, int n, int n2) {
        if (nArray[n2] <= 0) {
            return;
        }
        if (xS11AllCM.maxOccurs(n2) == -1) {
            nArray2[2] = nArray2[2] + n;
            if (nArray[n2] + n > xS11AllCM.minOccurs(n2)) {
                nArray[n2] = xS11AllCM.minOccurs(n2);
            } else {
                int n3 = n2;
                nArray[n3] = nArray[n3] + n;
            }
        } else {
            if (n > xS11AllCM.maxOccurs(n2) - nArray[n2]) {
                n = xS11AllCM.maxOccurs(n2) - nArray[n2];
            }
            int n4 = n2;
            nArray[n4] = nArray[n4] + n;
            nArray2[2] = nArray2[2] + n;
        }
    }

    static final class Occurence {
        final int minOccurs;
        final int maxOccurs;
        int elemIndex;

        public Occurence(XSCMRepeatingLeaf xSCMRepeatingLeaf, int n) {
            this.minOccurs = xSCMRepeatingLeaf.getMinOccurs();
            this.maxOccurs = xSCMRepeatingLeaf.getMaxOccurs();
            this.elemIndex = n;
        }

        public String toString() {
            return "minOccurs=" + this.minOccurs + ";maxOccurs=" + (this.maxOccurs != -1 ? Integer.toString(this.maxOccurs) : "unbounded");
        }
    }
}

