/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.alternative;

import java.util.HashMap;
import org.apache.xerces.dom.PSVIAttrNSImpl;
import org.apache.xerces.dom.PSVIDocumentImpl;
import org.apache.xerces.impl.xpath.XPath20;
import org.apache.xerces.impl.xs.AbstractPsychoPathImpl;
import org.apache.xerces.impl.xs.alternative.XSTypeAlternativeImpl;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.w3c.dom.Element;

public class Test
extends AbstractPsychoPathImpl {
    protected final XSTypeAlternativeImpl fTypeAlternative;
    protected final XPath20 fXPath;
    protected final XPath fXPathPsychoPath;
    protected final NamespaceSupport fXPath2NamespaceContext;

    public Test(XPath20 xPath20, XSTypeAlternativeImpl xSTypeAlternativeImpl, NamespaceSupport namespaceSupport) {
        this.fXPath = xPath20;
        this.fXPathPsychoPath = null;
        this.fTypeAlternative = xSTypeAlternativeImpl;
        this.fXPath2NamespaceContext = namespaceSupport;
    }

    public Test(XPath xPath, XSTypeAlternativeImpl xSTypeAlternativeImpl, NamespaceSupport namespaceSupport) {
        this.fXPath = null;
        this.fXPathPsychoPath = xPath;
        this.fTypeAlternative = xSTypeAlternativeImpl;
        this.fXPath2NamespaceContext = namespaceSupport;
    }

    public XSTypeAlternativeImpl getTypeAlternative() {
        return this.fTypeAlternative;
    }

    public Object getXPath() {
        XPath20 xPath20 = null;
        if (this.fXPath != null) {
            xPath20 = this.fXPath;
        } else if (this.fXPathPsychoPath != null) {
            xPath20 = this.fXPathPsychoPath;
        }
        return xPath20;
    }

    public boolean evaluateTest(QName qName, XMLAttributes xMLAttributes) {
        if (this.fXPath != null) {
            return this.fXPath.evaluateTest(qName, xMLAttributes);
        }
        if (this.fXPathPsychoPath != null) {
            return this.evaluateTestWithPsychoPath(qName, xMLAttributes);
        }
        return false;
    }

    public String toString() {
        return this.fXPath.toString();
    }

    private boolean evaluateTestWithPsychoPath(QName qName, XMLAttributes xMLAttributes) {
        boolean bl = false;
        try {
            PSVIDocumentImpl pSVIDocumentImpl = new PSVIDocumentImpl();
            Element element = pSVIDocumentImpl.createElementNS(qName.uri, qName.rawname);
            for (int i = 0; i < xMLAttributes.getLength(); ++i) {
                PSVIAttrNSImpl pSVIAttrNSImpl = new PSVIAttrNSImpl(pSVIDocumentImpl, xMLAttributes.getURI(i), xMLAttributes.getQName(i));
                pSVIAttrNSImpl.setNodeValue(xMLAttributes.getValue(i));
                element.setAttributeNode(pSVIAttrNSImpl);
            }
            pSVIDocumentImpl.appendChild(element);
            HashMap<String, NamespaceSupport> hashMap = new HashMap<String, NamespaceSupport>();
            hashMap.put("XPATH2_NS_CONTEXT", this.fXPath2NamespaceContext);
            this.initDynamicContext(null, pSVIDocumentImpl, hashMap);
            bl = this.evaluatePsychoPathExpr(this.fXPathPsychoPath, this.fTypeAlternative.fXPathDefaultNamespace, element);
        }
        catch (StaticError staticError) {
            bl = false;
        }
        catch (DynamicError dynamicError) {
            bl = false;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }
}

