/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import org.apache.xerces.impl.xs.util.StringListImpl;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSWildcard;

public class XSWildcardDecl
implements XSWildcard {
    public static final String ABSENT = null;
    public short fType = 1;
    public short fProcessContents = 1;
    public String[] fNamespaceList;
    public XSObjectList fAnnotations = null;
    public QName[] fDisallowedNamesList = null;
    public boolean fDisallowedDefined = false;
    public boolean fDisallowedSibling = false;
    private String fDescription = null;

    public boolean allowNamespace(String string) {
        int n;
        int n2;
        if (this.fType == 1) {
            return true;
        }
        if (this.fType == 2) {
            n2 = 0;
            n = this.fNamespaceList.length;
            for (int i = 0; i < n && n2 == 0; ++i) {
                if (string != this.fNamespaceList[i]) continue;
                n2 = 1;
            }
            if (n2 == 0) {
                return true;
            }
        }
        if (this.fType == 3) {
            n2 = this.fNamespaceList.length;
            for (n = 0; n < n2; ++n) {
                if (string != this.fNamespaceList[n]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean allowQName(QName qName) {
        if (this.allowNamespace(qName.uri)) {
            if (this.fDisallowedNamesList == null || this.fDisallowedNamesList.length == 0) {
                return true;
            }
            return this.isNameAllowed(qName.uri, qName.localpart);
        }
        return false;
    }

    private boolean isNameAllowed(String string, String string2) {
        for (int i = 0; i < this.fDisallowedNamesList.length; ++i) {
            if (this.fDisallowedNamesList[i].uri != string || this.fDisallowedNamesList[i].localpart != string2) continue;
            return false;
        }
        return true;
    }

    public boolean weakerProcessContents(XSWildcardDecl xSWildcardDecl) {
        return this.fProcessContents == 3 && xSWildcardDecl.fProcessContents == 1 || this.fProcessContents == 2 && xSWildcardDecl.fProcessContents != 2;
    }

    public String toString() {
        if (this.fDescription == null) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("WC[");
            switch (this.fType) {
                case 1: {
                    stringBuffer.append("##any");
                    break;
                }
                case 2: {
                    stringBuffer.append("##other");
                    stringBuffer.append(':');
                }
                case 3: {
                    if (this.fNamespaceList.length == 0) break;
                    stringBuffer.append("\"");
                    if (this.fNamespaceList[0] != null) {
                        stringBuffer.append(this.fNamespaceList[0]);
                    }
                    stringBuffer.append("\"");
                    for (n = 1; n < this.fNamespaceList.length; ++n) {
                        stringBuffer.append(",\"");
                        if (this.fNamespaceList[n] != null) {
                            stringBuffer.append(this.fNamespaceList[n]);
                        }
                        stringBuffer.append("\"");
                    }
                    break;
                }
            }
            if (this.fDisallowedNamesList != null) {
                stringBuffer.append(", notQName(");
                if (this.fDisallowedNamesList.length > 0) {
                    stringBuffer.append(this.fDisallowedNamesList[0]);
                    for (n = 1; n < this.fDisallowedNamesList.length; ++n) {
                        stringBuffer.append(", ");
                        stringBuffer.append(this.fDisallowedNamesList[n]);
                    }
                }
                if (this.fDisallowedDefined) {
                    stringBuffer.append(", ");
                    stringBuffer.append("##defined");
                }
                if (this.fDisallowedSibling) {
                    stringBuffer.append(", ");
                    stringBuffer.append("##definedSibling");
                }
                stringBuffer.append(')');
            }
            stringBuffer.append(']');
            this.fDescription = stringBuffer.toString();
        }
        return this.fDescription;
    }

    public short getType() {
        return 9;
    }

    public String getName() {
        return null;
    }

    public String getNamespace() {
        return null;
    }

    public short getConstraintType() {
        return this.fType;
    }

    public StringList getNsConstraintList() {
        return new StringListImpl(this.fNamespaceList, this.fNamespaceList == null ? 0 : this.fNamespaceList.length);
    }

    public short getProcessContents() {
        return this.fProcessContents;
    }

    public String getProcessContentsAsString() {
        switch (this.fProcessContents) {
            case 2: {
                return "skip";
            }
            case 3: {
                return "lax";
            }
            case 1: {
                return "strict";
            }
        }
        return "invalid value";
    }

    public XSAnnotation getAnnotation() {
        return this.fAnnotations != null ? (XSAnnotation)this.fAnnotations.item(0) : null;
    }

    public XSObjectList getAnnotations() {
        return this.fAnnotations != null ? this.fAnnotations : XSObjectListImpl.EMPTY_LIST;
    }

    public XSNamespaceItem getNamespaceItem() {
        return null;
    }
}

