/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Vector;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.alternative.Test;
import org.apache.xerces.impl.xs.alternative.XSTypeAlternativeImpl;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.impl.xs.util.XSTypeHelper;
import org.apache.xerces.util.IntStack;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;

public class XSDTypeAlternativeValidator {
    private Vector fInheritableAttrList = new Vector();
    private IntStack fInhrAttrCountStack = new IntStack();
    private final QName fTempQName = new QName();

    public XSTypeDefinition getCurrentType(XSElementDecl xSElementDecl, QName qName, XMLAttributes xMLAttributes) {
        XSTypeDefinition xSTypeDefinition = null;
        boolean bl = false;
        XSTypeAlternativeImpl[] xSTypeAlternativeImplArray = xSElementDecl.getTypeAlternatives();
        if (xSTypeAlternativeImplArray != null) {
            XSTypeAlternativeImpl xSTypeAlternativeImpl;
            XMLAttributes xMLAttributes2 = this.getAttributesForCTA(xMLAttributes);
            for (int i = 0; i < xSTypeAlternativeImplArray.length; ++i) {
                Test test = xSTypeAlternativeImplArray[i].getTest();
                if (test == null || !test.evaluateTest(qName, xMLAttributes2)) continue;
                xSTypeDefinition = xSTypeAlternativeImplArray[i].getTypeDefinition();
                bl = true;
                break;
            }
            if (!bl && (xSTypeAlternativeImpl = xSElementDecl.getDefaultTypeDefinition()) != null) {
                xSTypeDefinition = xSTypeAlternativeImpl.getTypeDefinition();
            }
        }
        return xSTypeDefinition;
    }

    public void handleStartElement(XSElementDecl xSElementDecl, XMLAttributes xMLAttributes) {
        this.fInhrAttrCountStack.push(this.fInheritableAttrList.size());
        if (xMLAttributes.getLength() > 0) {
            this.saveInheritableAttributes(xSElementDecl, xMLAttributes);
        }
    }

    public void handleEndElement() {
        if (this.fInhrAttrCountStack.size() > 0) {
            this.fInheritableAttrList.setSize(this.fInhrAttrCountStack.pop());
        }
    }

    private XMLAttributes getAttributesForCTA(XMLAttributes xMLAttributes) {
        Object object;
        int n;
        XMLAttributesImpl xMLAttributesImpl = new XMLAttributesImpl();
        for (n = 0; n < xMLAttributes.getLength(); ++n) {
            object = new QName();
            xMLAttributes.getName(n, (QName)object);
            xMLAttributesImpl.addAttribute((QName)object, xMLAttributes.getType(n), xMLAttributes.getValue(n));
        }
        for (n = this.fInheritableAttrList.size() - 1; n > -1; --n) {
            object = (InheritableAttribute)this.fInheritableAttrList.elementAt(n);
            if (this.attributeExists(xMLAttributesImpl, (InheritableAttribute)object)) continue;
            String string = "".equals(((InheritableAttribute)object).getPrefix()) ? ((InheritableAttribute)object).getLocalName() : ((InheritableAttribute)object).getPrefix() + ":" + ((InheritableAttribute)object).getLocalName();
            this.fTempQName.setValues(((InheritableAttribute)object).getPrefix(), ((InheritableAttribute)object).getLocalName(), string, ((InheritableAttribute)object).getUri());
            xMLAttributesImpl.addAttribute(this.fTempQName, ((InheritableAttribute)object).getType(), ((InheritableAttribute)object).getValue());
        }
        return xMLAttributesImpl;
    }

    private void saveInheritableAttributes(XSElementDecl xSElementDecl, XMLAttributes xMLAttributes) {
        if (xSElementDecl != null && xSElementDecl.fType instanceof XSComplexTypeDecl) {
            XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSElementDecl.fType;
            XSObjectListImpl xSObjectListImpl = (XSObjectListImpl)xSComplexTypeDecl.getAttributeUses();
            for (int i = 0; i < xMLAttributes.getLength(); ++i) {
                String string = xMLAttributes.getLocalName(i);
                String string2 = xMLAttributes.getURI(i);
                for (int j = 0; j < xSObjectListImpl.getLength(); ++j) {
                    XSAttributeUseImpl xSAttributeUseImpl = (XSAttributeUseImpl)xSObjectListImpl.get(j);
                    XSAttributeDeclaration xSAttributeDeclaration = xSAttributeUseImpl.getAttrDeclaration();
                    if (!string.equals(xSAttributeDeclaration.getName()) || !XSTypeHelper.isUriEqual(string2, xSAttributeDeclaration.getNamespace()) || !xSAttributeUseImpl.getInheritable()) continue;
                    InheritableAttribute inheritableAttribute = new InheritableAttribute(xMLAttributes.getLocalName(i), xMLAttributes.getPrefix(i), xMLAttributes.getURI(i), xMLAttributes.getValue(i), xMLAttributes.getType(i));
                    this.fInheritableAttrList.add(inheritableAttribute);
                }
            }
        }
    }

    private boolean attributeExists(XMLAttributes xMLAttributes, InheritableAttribute inheritableAttribute) {
        boolean bl = false;
        for (int i = 0; i < xMLAttributes.getLength(); ++i) {
            String string = xMLAttributes.getLocalName(i);
            String string2 = xMLAttributes.getURI(i);
            if (!string.equals(inheritableAttribute.getLocalName()) || !XSTypeHelper.isUriEqual(string2, inheritableAttribute.getUri())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    final class InheritableAttribute {
        private final String localName;
        private final String prefix;
        private final String uri;
        private final String value;
        private final String type;

        public InheritableAttribute(String string, String string2, String string3, String string4, String string5) {
            this.localName = string;
            this.prefix = string2;
            this.uri = string3;
            this.value = string4;
            this.type = string5;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getUri() {
            return this.uri;
        }

        public String getValue() {
            return this.value;
        }

        public String getType() {
            return this.type;
        }
    }
}

