/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath;

import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xpath.XPathSyntaxTreeNode;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;

class LiteralNode
extends XPathSyntaxTreeNode {
    private String value;
    private boolean isNumeric;

    public LiteralNode(String string, boolean bl) {
        this.value = string;
        this.isNumeric = bl;
    }

    public boolean evaluate(QName qName, XMLAttributes xMLAttributes) throws Exception {
        Object object = this.getValue(xMLAttributes);
        if (this.isNumeric) {
            return object != null && 0.0 != (Double)object;
        }
        return object != null;
    }

    public Object getValue(XMLAttributes xMLAttributes) throws Exception {
        XSSimpleType xSSimpleType = this.isNumeric ? dvFactory.getBuiltInType("double") : dvFactory.getBuiltInType("string");
        return xSSimpleType.validate(this.value, null, null);
    }

    public String getStringValue() {
        return this.value;
    }

    public int getType() {
        return this.isNumeric ? 0 : 1;
    }
}

