/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.schemas;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import ru.softlogic.schemas.XsdValidator;

class Schemas {
    private Schemas() {
    }

    public static void main(String[] args) throws FileNotFoundException, ParserConfigurationException, SAXException, TransformerException, IOException {
        long l = System.currentTimeMillis();
        String xml = "test/schemas/adv/169.xml";
        List<SAXParseException> exceptions = XsdValidator.validateXml(new File(xml), true);
        if (!exceptions.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (SAXParseException spe : exceptions) {
                sb.append(spe.getLineNumber()).append(":");
                sb.append(spe.getColumnNumber()).append("   ");
                sb.append(spe.getMessage().replaceAll("(\\s){2,}", " ")).append('\n');
            }
            System.out.println(sb.toString());
            System.out.println("Number: " + exceptions.size());
        } else {
            System.out.println("XML is valid");
        }
        System.out.println("Time: " + (float)(System.currentTimeMillis() - l) / 1000.0f + "s");
    }
}

