/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import java.text.NumberFormat;

public class MoneyToStr {
    private static final String RubOneUnit = "\u0440\u0443\u0431\u043b\u044c";
    private static final String RubTwoUnit = "\u0440\u0443\u0431\u043b\u044f";
    private static final String RubFiveUnit = "\u0440\u0443\u0431\u043b\u0435\u0439";
    private static final String RubSex;
    private static final String KopOneUnit;
    private static final String KopTwoUnit;
    private static final String KopFiveUnit;
    private static final String KopSex;

    public void moneytostr(double theMoney, StringBuilder money2str) {
        int triadNum = 0;
        int intPart = (int)theMoney;
        int fractPart = (int)Math.round((theMoney - (double)intPart) * 100.0);
        if (intPart == 0) {
            money2str.append("\u041d\u043e\u043b\u044c ");
        }
        do {
            int theTriad = intPart % 1000;
            money2str.insert(0, MoneyToStr.triad2Word(theTriad, triadNum, RubSex));
            if (triadNum == 0) {
                int range10 = theTriad % 100 / 10;
                int range = theTriad % 10;
                if (range10 == 1) {
                    money2str = money2str.append(RubFiveUnit);
                } else {
                    switch (range) {
                        case 1: {
                            money2str = money2str.append(RubOneUnit);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            money2str = money2str.append(RubTwoUnit);
                            break;
                        }
                        default: {
                            money2str = money2str.append(RubFiveUnit);
                        }
                    }
                }
            }
            ++triadNum;
        } while ((intPart /= 1000) != 0);
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumIntegerDigits(2);
        nf.setMinimumIntegerDigits(2);
        String kkk = nf.format(fractPart);
        money2str = money2str.append(" ").append(kkk).append(" ");
        if (fractPart % 10 == 1) {
            money2str = money2str.append(KopOneUnit);
        } else {
            switch (fractPart % 10) {
                case 1: {
                    money2str = money2str.append(KopOneUnit);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    money2str = money2str.append(KopTwoUnit);
                    break;
                }
                default: {
                    money2str = money2str.append(KopFiveUnit);
                }
            }
        }
        money2str.setCharAt(0, Character.toUpperCase(money2str.charAt(0)));
    }

    private static String triad2Word(int triad, int triadNum, String Sex) {
        StringBuffer triadWord = new StringBuffer(28);
        if (triad == 0) {
            return triadWord.toString();
        }
        int range = triad / 100;
        switch (range) {
            default: {
                break;
            }
            case 1: {
                triadWord = triadWord.append("\u0441\u0442\u043e ");
                break;
            }
            case 2: {
                triadWord = triadWord.append("\u0434\u0432\u0435\u0441\u0442\u0438 ");
                break;
            }
            case 3: {
                triadWord = triadWord.append("\u0442\u0440\u0438\u0441\u0442\u0430 ");
                break;
            }
            case 4: {
                triadWord = triadWord.append("\u0447\u0435\u0442\u044b\u0440\u0435\u0441\u0442\u0430 ");
                break;
            }
            case 5: {
                triadWord = triadWord.append("\u043f\u044f\u0442\u044c\u0441\u043e\u0442 ");
                break;
            }
            case 6: {
                triadWord = triadWord.append("\u0448\u0435\u0441\u0442\u044c\u0441\u043e\u0442 ");
                break;
            }
            case 7: {
                triadWord = triadWord.append("\u0441\u0435\u043c\u044c\u0441\u043e\u0442 ");
                break;
            }
            case 8: {
                triadWord = triadWord.append("\u0432\u043e\u0441\u0435\u043c\u044c\u0441\u043e\u0442 ");
                break;
            }
            case 9: {
                triadWord = triadWord.append("\u0434\u0435\u0432\u044f\u0442\u044c\u0441\u043e\u0442 ");
            }
        }
        range = triad % 100 / 10;
        switch (range) {
            default: {
                break;
            }
            case 2: {
                triadWord = triadWord.append("\u0434\u0432\u0430\u0434\u0446\u0430\u0442\u044c ");
                break;
            }
            case 3: {
                triadWord = triadWord.append("\u0442\u0440\u0438\u0434\u0446\u0430\u0442\u044c ");
                break;
            }
            case 4: {
                triadWord = triadWord.append("\u0441\u043e\u0440\u043e\u043a ");
                break;
            }
            case 5: {
                triadWord = triadWord.append("\u043f\u044f\u0442\u044c\u0434\u0435\u0441\u044f\u0442 ");
                break;
            }
            case 6: {
                triadWord = triadWord.append("\u0448\u0435\u0441\u0442\u044c\u0434\u0435\u0441\u044f\u0442 ");
                break;
            }
            case 7: {
                triadWord = triadWord.append("\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442 ");
                break;
            }
            case 8: {
                triadWord = triadWord.append("\u0432\u043e\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442 ");
                break;
            }
            case 9: {
                triadWord = triadWord.append("\u0434\u0435\u0432\u044f\u043d\u043e\u0441\u0442\u043e ");
            }
        }
        int range10 = range;
        range = triad % 10;
        if (range10 == 1) {
            switch (range) {
                case 0: {
                    triadWord = triadWord.append("\u0434\u0435\u0441\u044f\u0442\u044c ");
                    break;
                }
                case 1: {
                    triadWord = triadWord.append("\u043e\u0434\u0438\u043d\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                    break;
                }
                case 2: {
                    triadWord = triadWord.append("\u0434\u0432\u0435\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                    break;
                }
                case 3: {
                    triadWord = triadWord.append("\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                    break;
                }
                case 4: {
                    triadWord = triadWord.append("\u0447\u0435\u0442\u044b\u0440\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                    break;
                }
                case 5: {
                    triadWord = triadWord.append("\u043f\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                    break;
                }
                case 6: {
                    triadWord = triadWord.append("\u0448\u0435\u0441\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                    break;
                }
                case 7: {
                    triadWord = triadWord.append("\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                    break;
                }
                case 8: {
                    triadWord = triadWord.append("\u0432\u043e\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                    break;
                }
                case 9: {
                    triadWord = triadWord.append("\u0434\u0435\u0432\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                }
            }
        } else {
            switch (range) {
                default: {
                    break;
                }
                case 1: {
                    if (triadNum == 1) {
                        triadWord = triadWord.append("\u043e\u0434\u043d\u0430 ");
                    } else if (Sex.equals("M")) {
                        triadWord = triadWord.append("\u043e\u0434\u0438\u043d ");
                    }
                    if (!Sex.equals("F")) break;
                    triadWord = triadWord.append("\u043e\u0434\u043d\u0430 ");
                    break;
                }
                case 2: {
                    if (triadNum == 1) {
                        triadWord = triadWord.append("\u0434\u0432\u0435 ");
                    } else if (Sex.equals("M")) {
                        triadWord = triadWord.append("\u0434\u0432\u0430 ");
                    }
                    if (!Sex.equals("F")) break;
                    triadWord = triadWord.append("\u0434\u0432\u0435 ");
                    break;
                }
                case 3: {
                    triadWord = triadWord.append("\u0442\u0440\u0438 ");
                    break;
                }
                case 4: {
                    triadWord = triadWord.append("\u0447\u0435\u0442\u044b\u0440\u0435 ");
                    break;
                }
                case 5: {
                    triadWord = triadWord.append("\u043f\u044f\u0442\u044c ");
                    break;
                }
                case 6: {
                    triadWord = triadWord.append("\u0448\u0435\u0441\u0442\u044c ");
                    break;
                }
                case 7: {
                    triadWord = triadWord.append("\u0441\u0435\u043c\u044c ");
                    break;
                }
                case 8: {
                    triadWord = triadWord.append("\u0432\u043e\u0441\u0435\u043c\u044c ");
                    break;
                }
                case 9: {
                    triadWord = triadWord.append("\u0434\u0435\u0432\u044f\u0442\u044c ");
                }
            }
        }
        block44 : switch (triadNum) {
            default: {
                break;
            }
            case 1: {
                if (range10 == 1) {
                    triadWord = triadWord.append("\u0442\u044b\u0441\u044f\u0447 ");
                    break;
                }
                switch (range) {
                    default: {
                        triadWord = triadWord.append("\u0442\u044b\u0441\u044f\u0447 ");
                        break block44;
                    }
                    case 1: {
                        triadWord = triadWord.append("\u0442\u044b\u0441\u044f\u0447\u0430 ");
                        break block44;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                }
                triadWord = triadWord.append("\u0442\u044b\u0441\u044f\u0447\u0438 ");
                break;
            }
            case 2: {
                if (range10 == 1) {
                    triadWord = triadWord.append("\u043c\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432 ");
                    break;
                }
                switch (range) {
                    default: {
                        triadWord = triadWord.append("\u043c\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432 ");
                        break block44;
                    }
                    case 1: {
                        triadWord = triadWord.append("\u043c\u0438\u043b\u043b\u0438\u043e\u043d ");
                        break block44;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                }
                triadWord = triadWord.append("\u043c\u0438\u043b\u043b\u0438\u043e\u043d\u0430 ");
                break;
            }
            case 3: {
                if (range10 == 1) {
                    triadWord = triadWord.append("\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u043e\u0432 ");
                    break;
                }
                switch (range) {
                    default: {
                        triadWord = triadWord.append("\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u043e\u0432 ");
                        break block44;
                    }
                    case 1: {
                        triadWord = triadWord.append("\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434 ");
                        break block44;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                }
                triadWord = triadWord.append("\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u0430 ");
                break;
            }
            case 4: {
                if (range10 == 1) {
                    triadWord = triadWord.append("\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432 ");
                    break;
                }
                switch (range) {
                    default: {
                        triadWord = triadWord.append("\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432 ");
                        break block44;
                    }
                    case 1: {
                        triadWord = triadWord.append("\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d ");
                        break block44;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                }
                triadWord = triadWord.append("\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u0430 ");
            }
        }
        return triadWord.toString();
    }

    public String getMoney(double money) {
        StringBuilder money2str = new StringBuilder();
        this.moneytostr(money, money2str);
        return money2str.toString();
    }

    public String getMoney(int money) {
        StringBuilder money2str = new StringBuilder();
        this.moneytostr((double)money * 1.0 / 100.0, money2str);
        return money2str.toString();
    }

    public String format(double money) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        nf.setGroupingUsed(false);
        return nf.format(money).replace(',', '.');
    }

    static {
        KopOneUnit = "\u043a\u043e\u043f\u0435\u0439\u043a\u0430";
        KopTwoUnit = "\u043a\u043e\u043f\u0435\u0439\u043a\u0438";
        KopFiveUnit = "\u043a\u043e\u043f\u0435\u0435\u043a";
        RubSex = "M";
        KopSex = "F";
    }
}

