/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import ru.softlogic.system.util.FileUtilException;

public class FileUtil {
    private FileUtil() {
    }

    public static File checkDir(String path) throws FileUtilException {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0443\u0442\u044c");
        }
        try {
            File file = new File(path);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new FileUtilException("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043f\u0443\u0442\u044c \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0435\u0439");
                }
                if (!file.canExecute()) {
                    throw new FileUtilException("\u0414\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0434\u043b\u044f \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430");
                }
                if (!file.canRead()) {
                    throw new FileUtilException("\u0414\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f");
                }
                if (!file.canWrite()) {
                    throw new FileUtilException("\u0414\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438");
                }
            } else if (!file.mkdirs()) {
                throw new FileUtilException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044e");
            }
            return file;
        }
        catch (Throwable ex) {
            throw new FileUtilException(ex.getMessage());
        }
    }

    public static File checkFile(String path) throws FileUtilException {
        if (path == null) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0443\u0442\u044c");
        }
        try {
            File file = new File(path);
            if (file.exists()) {
                if (!file.isFile()) {
                    throw new FileUtilException("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043f\u0443\u0442\u044c \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0444\u0430\u0439\u043b\u043e\u043c");
                }
                if (!file.canRead()) {
                    throw new FileUtilException("\u0424\u0430\u0439\u043b \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f");
                }
                if (!file.canWrite()) {
                    throw new FileUtilException("\u0424\u0430\u0439\u043b \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438");
                }
            } else {
                FileUtil.checkDir(file.getParent());
                if (!file.createNewFile()) {
                    throw new FileUtilException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u0430\u0439\u043b");
                }
            }
            return file;
        }
        catch (Throwable ex) {
            throw new FileUtilException(ex.getMessage());
        }
    }

    public static boolean checkFileExists(String path) {
        if (path == null) {
            return false;
        }
        try {
            File file = new File(path);
            if (file.exists() && file.isFile() && file.canRead()) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean mkParentDirs(File file) throws FileUtilException {
        if (!file.getParentFile().exists()) {
            if (FileUtil.mkParentDirs(file.getParentFile())) {
                return file.getParentFile().mkdir();
            }
            throw new FileUtilException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044e " + file.getParentFile().getAbsolutePath());
        }
        return true;
    }

    public static long calculateChecksum(File file) throws FileUtilException {
        long l;
        CRC32 cs = new CRC32();
        cs.reset();
        FileInputStream fis = null;
        try {
            int l2;
            fis = new FileInputStream(file);
            byte[] buf = new byte[1024];
            while ((l2 = fis.read(buf)) >= 0) {
                cs.update(buf, 0, l2);
            }
            fis.close();
            l = cs.getValue();
        }
        catch (Exception ex) {
            try {
                throw new FileUtilException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0434\u0441\u0447\u0435\u0442\u0435 crc32", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        return l;
    }

    public static void unZip(File zipFile, File dir) throws FileUtilException {
        try (ZipFile zip = new ZipFile(zipFile);){
            if (!dir.exists()) {
                dir.mkdirs();
            }
            Enumeration<? extends ZipEntry> entries = zip.entries();
            LinkedList<ZipEntry> zfiles = new LinkedList<ZipEntry>();
            while (entries.hasMoreElements()) {
                ZipEntry entry2 = entries.nextElement();
                if (entry2.isDirectory()) {
                    new File(dir, entry2.getName()).mkdir();
                    continue;
                }
                zfiles.add(entry2);
            }
            zfiles.forEach(entry -> {
                try (InputStream in = zip.getInputStream((ZipEntry)entry);
                     FileOutputStream out = new FileOutputStream(new File(dir, entry.getName()));){
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = in.read(buffer)) >= 0) {
                        ((OutputStream)out).write(buffer, 0, len);
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
        catch (Exception ex) {
            throw new FileUtilException(ex);
        }
    }
}

