/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.update.updater;

import java.io.File;
import java.util.List;
import ru.softlogic.update.updater.StateListener;
import ru.softlogic.update.updater.UpdateControl;
import ru.softlogic.update.updater.UpdateItem;
import ru.softlogic.update.updater.UpdateStore;
import ru.softlogic.update.updater.filter.Filter;

public class UpdateRequest {
    private final UpdateStore updateStore;
    private final UpdateControl updateControl;
    private final File appDir;
    private final File updateDir;
    private final File list;
    private final StateListener stateListener;
    private final Filter filter;
    private final List<UpdateItem> items;

    public UpdateRequest(UpdateStore updateStore, UpdateControl updateControl, Filter filter, File appDir, File updateDir, File list, StateListener stateListener, List<UpdateItem> items) {
        if (updateStore == null) {
            throw new NullPointerException("Update store must be specify");
        }
        if (updateControl == null) {
            throw new NullPointerException("Update control must be specify");
        }
        if (appDir == null) {
            throw new NullPointerException("Application dir must be specify");
        }
        if (list == null) {
            throw new NullPointerException("List must be specify");
        }
        if (updateDir == null) {
            throw new NullPointerException("Update dir store must be specify");
        }
        if (stateListener == null) {
            throw new NullPointerException("State listener store must be specify");
        }
        this.updateStore = updateStore;
        this.updateControl = updateControl;
        this.filter = filter;
        this.appDir = appDir;
        this.updateDir = updateDir;
        this.list = list;
        this.stateListener = stateListener;
        this.items = items;
    }

    public File getAppDir() {
        return this.appDir;
    }

    public UpdateControl getUpdateControl() {
        return this.updateControl;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public File getUpdateDir() {
        return this.updateDir;
    }

    public File getList() {
        return this.list;
    }

    public UpdateStore getUpdateStore() {
        return this.updateStore;
    }

    public StateListener getStateListener() {
        return this.stateListener;
    }

    public List<UpdateItem> getItems() {
        return this.items;
    }
}

