/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.update.updater;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import ru.softlogic.update.updater.ListInfo;
import ru.softlogic.update.updater.ProgressListener;
import ru.softlogic.update.updater.UpdateItem;
import ru.softlogic.update.updater.UpdateStore;
import ru.softlogic.update.updater.exceptions.InvalidStoreException;
import ru.softlogic.update.updater.exceptions.RemoteFileNotFoundException;

public class FileUpdateStore
implements UpdateStore {
    private final File path;

    public FileUpdateStore(File path) {
        if (path == null) {
            throw new NullPointerException("Path");
        }
        this.path = path;
    }

    @Override
    public String getUrl() {
        return this.path.getAbsolutePath();
    }

    @Override
    public ListInfo getListInfo() throws IOException, RemoteFileNotFoundException {
        String content = FileUtils.readFileToString((File)new File(this.path, "nlist.crc"));
        if (content == null || content.isEmpty()) {
            throw new IOException("Data is not correct: " + content);
        }
        for (String line : content.split("\n")) {
            String[] dt;
            String f = line.trim();
            if (!f.matches("^(\\d+) (\\d+) (\\d+) (\\S+)$") || !"nlist.xml.gz".equals((dt = f.split(" "))[3])) continue;
            return new ListInfo(dt[3], Long.parseLong(dt[0]), Integer.parseInt(dt[1]), Long.parseLong(dt[2]));
        }
        throw new RemoteFileNotFoundException("Record with file nlist.xml.gz is not found. Content: " + content);
    }

    @Override
    public void download(UpdateItem item, File dest, ProgressListener listener, String addInfo) throws IOException, RemoteFileNotFoundException, InvalidStoreException {
        if (item == null) {
            throw new NullPointerException("UpdateItem");
        }
        if (dest == null) {
            throw new NullPointerException("Dest");
        }
        File src = new File(this.path, item.getFilename());
        if (!src.canRead()) {
            throw new RemoteFileNotFoundException("File " + src.getAbsolutePath() + " is not exist");
        }
        FileUtils.copyFile((File)src, (File)dest);
    }

    @Override
    public void close() {
    }
}

