/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.update.updater;

import ru.softlogic.update.updater.UpdateControl;

public class AutoUpdateControl
implements UpdateControl {
    private final int retryCount;

    public AutoUpdateControl(int retryCount) {
        if (retryCount < 1 || retryCount > 10) {
            throw new IllegalArgumentException("Retry count must be in range 1..10");
        }
        this.retryCount = retryCount;
    }

    @Override
    public boolean confirmUpdate(int size) {
        return true;
    }

    @Override
    public boolean confirmRetry(int errorCount, Exception ex) {
        return errorCount < this.retryCount;
    }
}

