/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.update.postproc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ru.softlogic.update.postproc.FileProcessor;

public class TarDecompressor
implements FileProcessor {
    private final Logger log;
    private final byte[] buffer = new byte[5000];

    public TarDecompressor(Logger log) {
        this.log = Objects.requireNonNull(log, "Logger is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(File f) throws IOException {
        this.log.info((Object)("    " + f));
        String srcPath = f.getParent();
        FileInputStream fin = null;
        BufferedInputStream in = null;
        TarArchiveInputStream gzIn = null;
        try {
            TarArchiveEntry tae;
            fin = new FileInputStream(f);
            in = new BufferedInputStream(fin);
            gzIn = new TarArchiveInputStream((InputStream)in);
            while ((tae = gzIn.getNextTarEntry()) != null) {
                this.log.info((Object)("        ->" + tae.getName() + ", size=" + tae.getSize()));
                if (tae.getSize() == 0L) {
                    File dir = new File(srcPath, tae.getName());
                    dir.mkdirs();
                    continue;
                }
                File nf = new File(srcPath, tae.getName());
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(nf);
                    int n = 0;
                    while (-1 != (n = gzIn.read(this.buffer))) {
                        out.write(this.buffer, 0, n);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
            this.log.info((Object)"        Uncompress successfully finished");
        }
        catch (IOException ex) {
            try {
                throw new IOException("An error occurred while uncompressing file: " + f, ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fin);
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(gzIn);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fin);
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((InputStream)gzIn);
        if (f.delete()) {
            this.log.info((Object)"        Tar archive successfully removed");
        } else {
            this.log.info((Object)"        An error occurred while removing the tar archive");
        }
    }
}

