/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.update.postproc;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.log4j.Logger;

public class Maintenance {
    public static final String ACTION_REMOVE = "rm";
    public static final String ACTION_REMOVE_UPDATE = "rmu";
    public static final String ACTION_MOVE = "mv";

    public boolean serve(File appDir, File updateDir, File rulesFile, Logger log) {
        if (appDir == null) {
            throw new NullPointerException("appDir");
        }
        if (updateDir == null) {
            throw new NullPointerException("updateDir");
        }
        if (log == null) {
            throw new NullPointerException("log");
        }
        boolean success = true;
        log.info((Object)"Start software maintenance");
        try {
            List lines = FileUtils.readLines((File)rulesFile);
            if (!lines.isEmpty()) {
                for (String line : lines) {
                    log.info((Object)("Process rule: " + line));
                    String[] rule = line.trim().replaceAll(" {2,}", " ").split(" ");
                    if (rule.length == 2 || rule.length == 3) {
                        String file;
                        String cmd = rule[0];
                        String option = rule.length == 2 ? "" : rule[1];
                        String string = file = rule.length == 2 ? rule[1] : rule[2];
                        if (file.contains("../")) {
                            log.info((Object)"Wrong path");
                            continue;
                        }
                        switch (cmd) {
                            case "rm": {
                                success &= Maintenance.deleteFile(new File(appDir, file), option, log);
                                break;
                            }
                            case "rmu": {
                                success &= Maintenance.deleteFile(new File(appDir, file), option, log);
                                Maintenance.deleteFile(new File(updateDir, file), option, log);
                                break;
                            }
                            default: {
                                log.error((Object)("Unknown action: " + rule[0] + ", skip"));
                                break;
                            }
                        }
                        continue;
                    }
                    log.info((Object)"Rule not correct");
                }
            } else {
                log.info((Object)"Noting to do");
            }
        }
        catch (IOException ex) {
            log.info((Object)"Maintenance rules not found");
        }
        return success;
    }

    private static boolean deleteFile(File file, String option, Logger log) {
        if (option == null || option.isEmpty()) {
            return Maintenance.deleteFile(file, log);
        }
        File dir = file.getParentFile();
        String tpl = file.getName();
        if (dir.isDirectory()) {
            switch (option) {
                case "wildcard": {
                    return Maintenance.deleteFilesFilter(dir, (FileFilter)new WildcardFileFilter(tpl, IOCase.INSENSITIVE), log);
                }
                case "regex": {
                    return Maintenance.deleteFilesFilter(dir, (FileFilter)new RegexFileFilter(tpl), log);
                }
            }
            log.info((Object)"Compatible options: wildcard, regex");
        } else {
            log.info((Object)("Wrong directory: " + dir.getAbsolutePath()));
        }
        return false;
    }

    private static boolean deleteFilesFilter(File dir, FileFilter filter, Logger log) {
        boolean success = true;
        for (File f : dir.listFiles(filter)) {
            success &= Maintenance.deleteFile(f, log);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean deleteFile(File file, Logger log) {
        block5: {
            block3: {
                block4: {
                    log.debug((Object)("    Try to remove file: " + file.getAbsolutePath()));
                    if (!file.exists()) break block3;
                    if (!file.delete()) break block4;
                    log.debug((Object)"    File deleted");
                    break block5;
                }
                log.error((Object)"Error on delete file, reset file & set flag 'delete on exit'");
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    IOUtils.closeQuietly(fos);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fos);
                file.deleteOnExit();
                return false;
            }
            log.debug((Object)("    File not exist: " + file.getAbsolutePath()));
        }
        return true;
    }
}

