/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.services.identify.bdpn;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import ru.softlogic.input.model.utils.FileUtil;
import ru.softlogic.services.identify.IdentifyUtil;
import ru.softlogic.services.identify.MobileIdentifier;

class BdpnPlainValidator
implements MobileIdentifier {
    private final File dir;
    private int[] num;
    private byte[] prov;
    private Map<Byte, Short> map;
    private Map<Short, Byte> map2;

    public BdpnPlainValidator(File dir) {
        this.dir = dir;
    }

    @Override
    public short getOperator(String number) {
        int pos = Arrays.binarySearch(this.num, Integer.parseInt(number));
        if (pos < 0) {
            return -1;
        }
        return this.map.get(this.prov[pos]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException {
        BufferedReader br = null;
        try {
            br = IdentifyUtil.getBufferedReader(this.dir, "defectors.csv");
            String line = br.readLine();
            if (line == null || !line.matches("\\d+")) {
                throw new IOException("Wrong header, record count must be numeric");
            }
            int count = Integer.parseInt(line);
            this.num = new int[count];
            this.prov = new byte[count];
            this.map = new HashMap<Byte, Short>();
            this.map2 = new HashMap<Short, Byte>();
            int i = 0;
            short oper = 0;
            int base = 0;
            while ((line = br.readLine()) != null) {
                Byte b;
                String[] params = line.split(":");
                this.num[i] = base += Integer.parseInt(params[0]);
                if (params.length > 1) {
                    oper = Short.parseShort(params[1]);
                }
                if ((b = this.map2.get(oper)) == null) {
                    b = (byte)this.map2.size();
                    this.map.put(b, oper);
                    this.map2.put(oper, b);
                }
                this.prov[i] = b;
                ++i;
            }
        }
        catch (Throwable throwable) {
            FileUtil.close((Closeable[])new Closeable[]{br});
            throw throwable;
        }
        FileUtil.close((Closeable[])new Closeable[]{br});
    }
}

