/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.services.identify;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.softlogic.input.model.utils.FileUtil;
import ru.softlogic.services.identify.CountryHandler;
import ru.softlogic.services.identify.MobileIdentifier;
import ru.softlogic.services.identify.MobileIdentifierFactory;

public class IdentifyService {
    public static final short UNKNOWN = -1;
    public static final short ERROR_RESOURCES = -2;
    private static final Logger log = LoggerFactory.getLogger((String)"pay");
    public static final short MCC_RU = 250;
    public static final short MCC_KZ = 401;
    public static final short MCC_DEFAULT = 0;
    private static Map<Short, CountryHandler> handlers;
    private static Set<Short> operators;
    private static File dir;

    private IdentifyService() {
    }

    public static void configure(File dir) throws IOException {
        if (dir == null) {
            throw new NullPointerException("Dir is null");
        }
        IdentifyService.dir = dir;
    }

    public static void update() {
        IdentifyService.checkInit();
        log.info("Update mobile identity resources");
        short defMcc = IdentifyService.getDefaultMcc();
        log.info("Default MCC: {}", (Object)defMcc);
        TreeMap<Short, CountryHandler> nh = new TreeMap<Short, CountryHandler>();
        if (dir.isDirectory()) {
            for (File f : dir.listFiles(new LocalFileFilter())) {
                try {
                    log.info("Process: {}", (Object)f.getPath());
                    CountryHandler ch = IdentifyService.loadCountry(f);
                    nh.put(Short.parseShort(f.getName()), ch);
                }
                catch (IOException ex) {
                    log.info("Error on loading", (Throwable)ex);
                }
            }
        }
        if (!nh.isEmpty()) {
            if (defMcc > 0 && nh.get(defMcc) != null) {
                log.info("Set default MCC to: {}", (Object)defMcc);
                nh.put((short)0, (CountryHandler)nh.get(defMcc));
            } else {
                short dm = (Short)nh.keySet().iterator().next();
                log.info("Set default MCC to: {}", (Object)dm);
                nh.put((short)0, (CountryHandler)nh.get(dm));
            }
        } else {
            log.error("Resources is not found");
        }
        handlers = nh;
        log.info("Done");
    }

    public static void setFilter(Set<Short> operators) {
        IdentifyService.checkInit();
        log.info("New service filter: {}", operators);
        IdentifyService.operators = operators;
    }

    public static short getOperator(short mnc, String number) {
        IdentifyService.checkInit();
        if (number == null) {
            throw new NullPointerException("Number is null");
        }
        CountryHandler ch = handlers.get(mnc);
        if (ch != null) {
            if (number.length() != ch.getLength()) {
                log.info("Wrong length");
                return -1;
            }
            if (!number.matches("\\d+")) {
                log.info("Wrong content, must be only digits");
                return -1;
            }
            if (number.charAt(0) != ch.getPrefix()) {
                log.info("Wrong prefix, must be {}", (Object)Character.valueOf(ch.getPrefix()));
                return -1;
            }
            number = number.substring(1);
            for (MobileIdentifier mi : ch.getIdentifiers()) {
                int prov = mi.getOperator(number);
                if (prov < 0) continue;
                return (short)(operators == null || operators.contains((short)prov) ? prov : -1);
            }
        } else {
            log.error("Country handler is not found");
        }
        return -1;
    }

    public static short getOperator(String number) {
        return IdentifyService.getOperator((short)0, number);
    }

    private static CountryHandler loadCountry(File path) throws IOException {
        Properties prop = new Properties();
        InputStream br = null;
        try {
            br = new FileInputStream(new File(path, "params.properties"));
            prop.load(br);
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        int len = Integer.parseInt(prop.getProperty("number.length", "10").trim());
        log.info("   number length: {}", (Object)len);
        char prefix = prop.getProperty("number.prefix", "9").charAt(0);
        log.info("   number prefix: {}", (Object)Character.valueOf(prefix));
        LinkedList<MobileIdentifier> mis = new LinkedList<MobileIdentifier>();
        for (String id : prop.getProperty("chain").split(",")) {
            try {
                MobileIdentifier mi = MobileIdentifierFactory.create(id, path);
                log.info("      Try to load: {}", (Object)id);
                mi.load();
                log.info("      Done");
                mis.add(mi);
            }
            catch (Exception ex) {
                log.error("Error on create mobile identifier", (Throwable)ex);
            }
        }
        return new CountryHandler(len, prefix, mis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static short getDefaultMcc() {
        short s;
        Properties prop = new Properties();
        FileInputStream br = null;
        try {
            br = new FileInputStream(new File(dir, "params.properties"));
            prop.load(br);
            s = Short.parseShort(prop.getProperty("default", "0").trim());
        }
        catch (Exception ex) {
            short s2;
            try {
                s2 = 0;
            }
            catch (Throwable throwable) {
                FileUtil.close((Closeable[])new Closeable[]{br});
                throw throwable;
            }
            FileUtil.close((Closeable[])new Closeable[]{br});
            return s2;
        }
        FileUtil.close((Closeable[])new Closeable[]{br});
        return s;
    }

    private static void checkInit() {
        if (dir == null) {
            throw new IllegalStateException("Service is not inited");
        }
    }

    private static final class LocalFileFilter
    implements FileFilter {
        private LocalFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() && pathname.getName().matches("\\d{3}");
        }
    }
}

