/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.uni.v2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.selector.custom.RedirectCustomData;
import ru.softlogic.input.model.field.table.TableColumn;
import ru.softlogic.input.model.field.table.TableField;
import ru.softlogic.input.model.field.table.TableItem;
import ru.softlogic.input.model.field.table.TableStaticStore;
import ru.softlogic.input.model.field.table.TableStore;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.parser.FormScreenAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.uni.v2.FormParserContext;
import ru.softlogic.parser.uni.v2.FormScreenParser;

@FormScreenAnnotation(name="table-field")
class TableScreen
extends FormScreenParser {
    TableScreen() {
    }

    @Override
    public ScreenDescription parse(FormParserContext parserContext, Element element) throws ParseException {
        ScreenDescription sd = new ScreenDescription("table");
        TableScreen.initScreen(sd, element);
        LinkedList<TableField> fields = new LinkedList<TableField>();
        fields.add(this.loadTableField(element));
        sd.setSequence(new FieldSequence(fields));
        String decor = TableScreen.getAttribute(element, "decor");
        sd.setDecor(decor);
        sd.setButtons(this.createKeyMap());
        this.setBarcodeScanner(sd, element);
        return sd;
    }

    public TableField loadTableField(Element element) throws ParseException {
        List<TableColumn> cols = this.parseColumns(TableScreen.getElement(element, "columns"));
        List<TableItem> items = this.parseItems(TableScreen.getElement(element, "items"));
        TableField tf = new TableField();
        this.prefillField((IdentityField)tf, element);
        tf.setReadonly(Boolean.valueOf(Boolean.parseBoolean(TableScreen.getAttribute(element, "readonly"))));
        tf.setStore((TableStore)new TableStaticStore(items));
        tf.setColumns(cols);
        TableColumn.calculateWidths(cols);
        return tf;
    }

    private List<TableColumn> parseColumns(Element element) {
        List<Element> childNodes = TableScreen.getChildElements(element);
        ArrayList<TableColumn> cols = new ArrayList<TableColumn>();
        for (int i = 0; i < childNodes.size(); ++i) {
            Element item = childNodes.get(i);
            if (!"column".equals(item.getTagName())) continue;
            TableColumn tc = new TableColumn();
            tc.setKey(TableScreen.getAttribute(item, "key"));
            tc.setTitle(TableScreen.getAttribute(item, "title"));
            tc.setTitleid(TableScreen.getAttribute(item, "title-id"));
            tc.setWidth(Double.parseDouble(TableScreen.getAttribute(item, "width")));
            cols.add(tc);
        }
        return cols;
    }

    private List<TableItem> parseItems(Element element) {
        ArrayList<TableItem> items = new ArrayList<TableItem>();
        List<Element> childNodes = TableScreen.getChildElements(element);
        for (int i = 0; i < childNodes.size(); ++i) {
            Element item = childNodes.get(i);
            if (!"item".equals(item.getTagName())) continue;
            HashMap<String, RedirectCustomData> custom = new HashMap<String, RedirectCustomData>();
            TableItem ti = new TableItem();
            LinkedList<InputElement> lie = new LinkedList<InputElement>();
            NodeList itemsNode = item.getChildNodes();
            for (int j = 0; j < itemsNode.getLength(); ++j) {
                if (!"cell".equals(itemsNode.item(j).getNodeName())) continue;
                Element cell = (Element)itemsNode.item(j);
                InputElement curcell = new InputElement(TableScreen.getAttribute(cell, "key"), TableScreen.getAttribute(cell, "key-title"), TableScreen.getAttribute(cell, "value"), TableScreen.getAttribute(cell, "value-title"), this.getFlags(cell));
                ti.getElements().put(TableScreen.getAttribute(cell, "key"), curcell);
                lie.add(curcell);
            }
            String redirect = TableScreen.getAttribute(item, "redirect");
            if (redirect != null) {
                custom.put("#redirect", new RedirectCustomData(Short.valueOf(Short.parseShort(redirect))));
            }
            ti.setCustomData(custom);
            Data d = new Data(lie);
            String sum = TableScreen.getAttribute(item, "sum");
            if (sum != null) {
                d.setSum(new TransactionSum(Float.parseFloat(sum)));
            }
            ti.setData(d);
            items.add(ti);
        }
        return items;
    }
}

