/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.decrypt;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import javax.xml.bind.DatatypeConverter;
import ru.softlogic.parser.decrypt.OpenSSLPBEInputStream;

public final class DecryptUtils {
    private static final String ALGORITHM = "PBEWITHMD5AND256BITAES-CBC-OPENSSL";

    private DecryptUtils() {
    }

    public static InputStream decrypt(File file, String password) throws IOException {
        if (password == null || password.isEmpty()) {
            throw new IOException("Password is not set");
        }
        RandomAccessFile f = new RandomAccessFile(file.getAbsolutePath(), "r");
        byte[] base64Data = new byte[(int)f.length()];
        f.readFully(base64Data);
        byte[] hexData = DatatypeConverter.parseBase64Binary((String)new String(base64Data));
        ByteArrayInputStream arrayStream = new ByteArrayInputStream(hexData);
        return new OpenSSLPBEInputStream(arrayStream, ALGORITHM, 1, password.toCharArray());
    }
}

