/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.adv.v2.fields;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.table.TableColumn;
import ru.softlogic.input.model.field.table.TableDataStore;
import ru.softlogic.input.model.field.table.TableField;
import ru.softlogic.input.model.field.table.TableItem;
import ru.softlogic.input.model.field.table.TableStaticStore;
import ru.softlogic.input.model.field.table.TableStore;
import ru.softlogic.parser.FieldAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.adv.v2.fields.FieldParser;

@FieldAnnotation(name="table-field")
public class TblField
extends FieldParser {
    @Override
    public List<? extends IdentityField> parse(Element element) throws ParseException {
        TableField tf = new TableField();
        this.prefillField((IdentityField)tf, element);
        Element columns = TblField.getElement(element, "columns");
        if (columns == null) {
            throw new ParseException("Table does not contains section 'columns'");
        }
        tf.setReadonly(Boolean.valueOf("true".equals(TblField.getAttribute(element, "read-only"))));
        tf.setEmptyText(TblField.getAttribute(element, "empty-text"));
        LinkedList<TableColumn> cols = new LinkedList<TableColumn>();
        for (Element column : TblField.getElements(columns, "column")) {
            TableColumn tc = new TableColumn();
            String key = TblField.getNotNullAttribute(column, "key", "Table.column does not contains attribute 'key'");
            String title = TblField.getAttribute(column, "title");
            String titleId = TblField.getAttribute(column, "title-id");
            double width = Double.parseDouble(TblField.getAttribute(column, "width"));
            tc.setKey(key);
            tc.setTitle(title);
            tc.setTitleid(titleId);
            tc.setWidth(width);
            cols.add(tc);
        }
        try {
            TableColumn.calculateWidths(cols);
            tf.setColumns(cols);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage());
        }
        Element itemsSection = TblField.getElement(element, "items");
        tf.setStore(this.parseTableStore(itemsSection));
        return Collections.singletonList(tf);
    }

    private TableStore parseTableStore(Element element) throws ParseException {
        if (element == null) {
            throw new ParseException("Table does not contains section 'items'");
        }
        String type = TblField.getAttribute(element, "type");
        if (type == null || "static".equals(type)) {
            LinkedList<TableItem> items = new LinkedList<TableItem>();
            for (Element item : TblField.getElements(element, "item")) {
                TableItem ti = new TableItem();
                LinkedList<InputElement> lie = new LinkedList<InputElement>();
                for (Element cell : TblField.getElements(item, "cell")) {
                    InputElement curcell = new InputElement(TblField.getAttribute(cell, "key"), TblField.getAttribute(cell, "key-title"), TblField.getAttribute(cell, "value"), TblField.getAttribute(cell, "value-title"), this.getFlags(cell));
                    ti.getElements().put(TblField.getAttribute(cell, "key"), curcell);
                    lie.add(curcell);
                }
                ti.setData(new Data(lie));
                String sum = TblField.getAttribute(item, "sum");
                if (sum != null) {
                    try {
                        ti.getData().setSum(new TransactionSum(Float.parseFloat(sum)));
                    }
                    catch (NumberFormatException ex) {
                        throw new ParseException("Table.Incorrect value of the sum: " + sum);
                    }
                }
                items.add(ti);
            }
            return new TableStaticStore(items);
        }
        if ("data".equals(type)) {
            return new TableDataStore(TblField.getAttribute(element, "key"));
        }
        throw new ParseException("Unknown type of storage: " + type);
    }
}

