/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.simple.Goto;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.ParserHelper;
import ru.softlogic.parser.adv.v2.ParserContext;
import ru.softlogic.parser.adv.v2.ScenarioParserW3C;
import ru.softlogic.parser.adv.v2.actions.ParseAction;
import ru.softlogic.parser.adv.v2.fields.FieldParser;

public final class ScenarioHelper {
    private ScenarioHelper() {
    }

    public static ActionMap createActionMap(Element element, ParserContext context) throws ParseException {
        String title;
        String type;
        Element actionSection = ParserHelper.getElement(element, "actions");
        if (actionSection == null) {
            return null;
        }
        List<Element> actionElements = ParserHelper.getElements(actionSection, "action");
        List<Element> gotoElements = ParserHelper.getElements(actionSection, "goto-action");
        if (actionElements.isEmpty() && gotoElements.isEmpty()) {
            return null;
        }
        ArrayList<Action> list = new ArrayList<Action>();
        for (Element el : actionElements) {
            type = ParserHelper.getAttribute(el, "type").toLowerCase();
            title = ParserHelper.getAttribute(el, "title");
            String titleId = ParserHelper.getAttribute(el, "title-id");
            Action act = new Action(type, title, titleId);
            act.setSequence(ScenarioHelper.createActionSequence(el, context));
            list.add(act);
        }
        for (Element el : gotoElements) {
            type = ParserHelper.getAttribute(el, "type").toLowerCase();
            title = ParserHelper.getAttribute(el, "title");
            String target = ParserHelper.getAttribute(el, "target");
            String titleId = ParserHelper.getAttribute(el, "title-id");
            Action act = new Action(type, title, titleId);
            ArrayList<Goto> result = new ArrayList<Goto>();
            result.add(new Goto(target));
            act.setSequence(result);
            list.add(act);
        }
        return new ActionMap(list);
    }

    public static List<ActionElement> createActionSequence(Element actionSection, ParserContext context) throws ParseException {
        List<Element> childElements = ParserHelper.getChildElements(actionSection);
        ArrayList<ActionElement> result = new ArrayList<ActionElement>();
        for (Element item : childElements) {
            ParseAction type = ScenarioParserW3C.getActionsMap().get(item.getNodeName());
            if (type == null) {
                throw new ParseException("Unknown type of item: " + item.getNodeName());
            }
            result.add(type.parse(item, context));
        }
        return result;
    }

    public static List<IdentityField> getFieldList(Element element) throws ParseException {
        ArrayList<IdentityField> result = new ArrayList<IdentityField>();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (item.getNodeType() != 1) continue;
            FieldParser type = ScenarioParserW3C.getFieldsMap().get(item.getNodeName());
            if (type == null) {
                throw new ParseException("Unknown item type: " + item.getNodeName());
            }
            result.addAll(type.parse((Element)item));
        }
        return result;
    }
}

