/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.softlogic.parser.ParseException;

public final class ParserHelper {
    private ParserHelper() {
    }

    public static Element getElement(Element element, String name) {
        NodeList nList = element.getChildNodes();
        for (int i = 0; i < nList.getLength(); ++i) {
            Node item = nList.item(i);
            if (!item.getNodeName().equals(name) || item.getNodeType() != 1) continue;
            return (Element)item;
        }
        return null;
    }

    public static List<Element> getElements(Element element, String name) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (element != null) {
            NodeList nList = element.getChildNodes();
            for (int i = 0; i < nList.getLength(); ++i) {
                Node nNode = nList.item(i);
                if (nNode.getNodeType() != 1 || !name.equals(nNode.getNodeName())) continue;
                list.add((Element)nNode);
            }
        }
        return list;
    }

    public static Element getNotNullElement(Element element, String name, String errorMessage) throws ParseException {
        Element el = ParserHelper.getElement(element, name);
        if (el == null) {
            throw new ParseException(errorMessage);
        }
        return el;
    }

    public static List<Element> getChildElements(Element element) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (element != null) {
            NodeList nList = element.getChildNodes();
            for (int i = 0; i < nList.getLength(); ++i) {
                Node nNode = nList.item(i);
                if (nNode.getNodeType() != 1) continue;
                list.add((Element)nNode);
            }
        }
        return list;
    }

    public static String getAttribute(Element el, String name) {
        if (el != null && el.hasAttribute(name)) {
            return el.getAttribute(name);
        }
        return null;
    }

    public static String getNotNullAttribute(Element el, String name, String msg) throws ParseException {
        String attribute = el.getAttribute(name);
        if (attribute.isEmpty()) {
            throw new ParseException(msg);
        }
        return attribute;
    }
}

