/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.processing;

import fxterm.app.FxEnv;
import fxterm.core.hdw.prt.PrnUtils;
import fxterm.core.task.Task;
import fxterm.core.timer.Timer;
import fxterm.module.Environment;
import fxterm.module.Pack;
import fxterm.module.PackUtility;
import fxterm.module.stage.payment.PMHelper;
import fxterm.module.stage.processing.BaseObsoleteProcessingModule;
import fxterm.session.Session;
import java.util.Locale;
import javafx.util.Pair;
import plfx.screen.popup.dialog.DialogDescriptor;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.hdw.dev.ioc.IOControllerException;
import ru.softlogic.hdw.dev.printer.spooler.PrinterJob;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.operation.Operation;
import ru.softlogic.srv.DataItem;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.operation.ProcessingResult;
import ru.softlogic.srv.api.operation.ProcessingResultType;
import ru.softlogic.srv.connector.ConnectorException;

public class PMDispenseProcessingModule
extends BaseObsoleteProcessingModule {
    private final int attempts = 5;
    private final int timeout = 30;

    protected void processingBegin(Environment environment, Operation operation) {
        this.environment = environment;
        this.log.info((Object)"Run online payment processing");
        new ProcessTask(environment, operation, Session.getLocale()).process();
    }

    protected void processingFinished(ProcessingResult result, Operation operation) {
        if (result != null && result.getType() == ProcessingResultType.Ok) {
            int cellNumber = -1;
            if (result.getDataItems() != null) {
                for (DataItem di : result.getDataItems()) {
                    String key = di.getKey();
                    String value = di.getValue();
                    operation.getForm().put(key, value);
                    operation.getViews().put(key, value);
                    if (operation.getTitles().get(key) == null) {
                        operation.getTitles().put(key, key);
                    }
                    operation.getInputElements().put(key, new InputElement(key, (String)operation.getTitles().get(key), value, value, 0));
                }
            }
            if (!Session.getPaymentEndingState().isCancel()) {
                cellNumber = PMHelper.extractCellNumber(result);
                this.log.info((Object)("Cell number: " + cellNumber));
                if (cellNumber == -1) {
                    this.log.info((Object)"Cell number isn't set. Show error dialog");
                    String errorText = PMHelper.extractErrorText(result);
                    this.log.info((Object)("Error text: " + errorText));
                    Dialog.show((DialogDescriptor)PMHelper.createErrorDDExtMsg(errorText), actionId -> this.cancel());
                } else {
                    this.dispense(cellNumber, operation);
                }
            } else {
                this._processingFinished(operation);
            }
        } else {
            this.cancel();
        }
    }

    private void dispense(int cellNumber, Operation operation) {
        this.log.info((Object)"Show success dialog");
        Dialog.show((DialogDescriptor)PMHelper.createCellNumberDispenseSuccessDD(cellNumber), actionId -> {
            try {
                this.log.info((Object)"Send open door command");
                PMHelper.setDoorTask(FxEnv.getIOController().getDoorApi().openDoor(cellNumber));
                this._processingFinished(operation);
            }
            catch (IOControllerException ex) {
                this.log.error((Object)ex, (Throwable)ex);
                PMHelper.stopOpeningDoor();
                FxEnv.getConnector().sendEvent(new Event[]{new Event(EventType.Sensor, "Error on open door: " + ex.getMessage())});
                Dialog.show((DialogDescriptor)PMHelper.createOpenDoorErrorDD(), i -> this.cancel());
            }
        });
    }

    public void cancel() {
        Pack pack = this.environment.getPack();
        this.log.info((Object)"Cancel operation");
        Pair opers = PackUtility.cancelOnlinePack((Pack)pack);
        Operation op = (Operation)opers.getKey();
        if (pack.isZeroAmount() && op.getPinCodeNominal() != null && op.getPinCodeNominal().isEmpty()) {
            op.setPinCode(null);
            op.setPinCodeNominal(null);
            pack.setZeroAmount(false);
            pack.setPaybackType(0);
        }
        this.log.info((Object)("Canceled operation: " + op));
        this.log.info((Object)"Save it to queue");
        try {
            FxEnv.getConnector().process(op);
            if (opers.getValue() != null) {
                this.log.info((Object)("Change operation: " + opers.getValue()));
                FxEnv.getPrintSpooler().print((PrinterJob)PrnUtils.createPrinterJob((Operation)((Operation)opers.getKey()), (boolean)pack.isPrintByOne()).get(0));
                op = (Operation)opers.getValue();
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"Error on save payment", (Throwable)ex);
        }
        this._processingFinished(op);
    }

    private void makeFullPayout(Environment environment) {
        PackUtility.cancelPack((Pack)environment.getPack());
        Session.getPaymentEndingState().setCancel(true);
        environment.getModules().getBeforePayoutModule().startPayout(environment);
    }

    class ProcessTask
    extends Task {
        private final Environment environment;
        private final Operation operation;
        private final Locale locale;

        public ProcessTask(Environment environment, Operation operation, Locale locale) {
            this.environment = environment;
            this.operation = operation;
            this.locale = locale;
        }

        protected String getWaitId() {
            return "input.verify.data";
        }

        protected Object execute() throws Exception {
            long time = Timer.currentSec();
            for (int i = 0; i < 5; ++i) {
                try {
                    PMDispenseProcessingModule.this.log.info((Object)("Pre-process request. Attempt " + (i + 1)));
                    FxEnv.getConnector().ping();
                    PMDispenseProcessingModule.this.log.info((Object)"Ping successed");
                    break;
                }
                catch (ConnectorException ex) {
                    if (i == 4 || Timer.currentSec() - time > 30L) {
                        return ex;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
            }
            PMDispenseProcessingModule.this.log.info((Object)"Process request");
            return FxEnv.getConnector().process(this.operation);
        }

        protected void onResult(Object object) {
            PMDispenseProcessingModule.this.log.info((Object)("Processing result: " + object));
            if (object instanceof ProcessingResult) {
                ProcessingResult pr = (ProcessingResult)object;
                if (pr.getType() == ProcessingResultType.Ok) {
                    PMDispenseProcessingModule.this.processingFinished((ProcessingResult)object, this.operation);
                } else {
                    PMDispenseProcessingModule.this.log.info((Object)"Ask about action");
                    Dialog.show((String)"module/processing/error_online", actionId -> {
                        PMDispenseProcessingModule.this.log.info((Object)("User make choise: " + actionId));
                        if (actionId == 0) {
                            PMDispenseProcessingModule.this.log.info((Object)"Go to input module");
                            this.environment.getModules().getInputModule().restore();
                        } else {
                            PMDispenseProcessingModule.this.log.info((Object)"Make full payout");
                            PMDispenseProcessingModule.this.makeFullPayout(this.environment);
                        }
                    });
                }
            } else {
                PMDispenseProcessingModule.this.log.info((Object)"Ask about retry");
                Dialog.show((String)"module/processing/error_ping_online", actionId -> {
                    PMDispenseProcessingModule.this.log.info((Object)("User make choise: " + actionId));
                    if (actionId == 0) {
                        PMDispenseProcessingModule.this.log.info((Object)"Retry run online payment processing");
                        new ProcessTask(this.environment, this.operation, Session.getLocale()).process();
                    } else {
                        PMDispenseProcessingModule.this.log.info((Object)"Make full payout");
                        PMDispenseProcessingModule.this.makeFullPayout(this.environment);
                    }
                });
            }
        }

        protected void onError(Exception ex) {
            PMDispenseProcessingModule.this.log.info((Object)"Error on online processing", (Throwable)ex);
            PMDispenseProcessingModule.this.processingFinished(null, this.operation);
        }
    }
}

