/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payment;

import fxterm.app.FxEnv;
import fxterm.core.BaseScreenListener;
import fxterm.core.task.Task;
import fxterm.module.Environment;
import fxterm.module.ExitIntent;
import fxterm.module.Intent;
import fxterm.module.Pack;
import fxterm.module.PackUtility;
import fxterm.module.Payment;
import fxterm.module.Restorable;
import fxterm.module.stage.payment.BackIntent;
import fxterm.module.stage.payment.BasePaymentModule;
import fxterm.module.stage.payment.PMHelper;
import fxterm.session.Session;
import fxterm.utils.FinUtils;
import java.util.List;
import java.util.Map;
import plfx.screen.Screen;
import plfx.screen.ScreenListener;
import plfx.screen.pay.CommonSumScreen;
import plfx.screen.popup.dialog.DialogDescriptor;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.cash.Sum;
import ru.softlogic.hdw.dev.ioc.IOControllerException;
import ru.softlogic.hdw.dev.sensors.Sensor;
import ru.softlogic.hdw.dev.sensors.SensorEvent;
import ru.softlogic.hdw.dev.sensors.SensorsListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;

public class PMLoadPaymentModule
extends BasePaymentModule {
    private Environment environment;
    private CommonSumScreen sumScreen;
    private CashScreenListener csl;
    private Sensor sensor;
    private SensorsListener sl = new LocalSensorListener();

    public void _startPayment(Environment environment, CommonSumScreen sumScreen, Pack restore) {
        this.environment = environment;
        Pack pack = environment.getPack();
        PackUtility.printPack((String)"Payment pack", (Pack)pack);
        Session.setPayments((List)pack.getPayments());
        this.csl = new CashScreenListener();
        this.sensor = null;
        PMHelper.setDoorTask(null);
        sumScreen.setListener((ScreenListener)this.csl);
        this.sumScreen = sumScreen;
        new CellNumberRequest().process();
    }

    public void cancel(Intent intent) {
        boolean timeout;
        this.log.info((Object)("Cancel was requested on payment module, intent =" + intent.getType()));
        boolean bl = timeout = intent.getType() == 0;
        if (timeout) {
            this.log.info((Object)"Payment cancel by timeout");
            Session.getPaymentEndingState().setChType(-1);
            this.removeListener();
            this.addDoorStatus("\u0414\u0432\u0435\u0440\u0446\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0430");
            this.process(1, timeout);
        } else if (intent.getType() == 3) {
            intent.process();
        } else {
            this.exit();
        }
    }

    public void initPaymentSchema() {
        this.log.info((Object)"Don't enable cash devices");
    }

    protected void process(int actionId, boolean timeout) {
        this.log.info((Object)("Begin process payment, actionId=" + actionId + ", timeout=" + timeout + ", keeper=null"));
        Pack pack = this.environment.getPack();
        Sum s0 = FinUtils.createVoidSum();
        SumResult sumResult = new SumResult(s0, s0, s0, s0, s0, s0, null);
        pack.setSumResult(sumResult);
        this.log.info((Object)"Process single operation pack");
        Payment p = (Payment)pack.getPayments().get(0);
        if (actionId == 0) {
            this.log.info((Object)"Set zero amount flag");
            pack.setZeroAmount(true);
            p.setSumOut(sumResult.getOut());
            PMHelper.preparePayment(p);
            Session.getPaymentEndingState().setCancel(false);
        } else {
            PMHelper.stopOpeningDoor();
            PackUtility.cancelPack((Pack)pack);
            p.setSumOut(FinUtils.createVoidSum());
            Session.getPaymentEndingState().setCancel(true);
        }
        this.startPayout(this.environment);
    }

    private void removeListener() {
        if (this.sensor != null) {
            this.sensor.removeListener(this.sl);
        }
    }

    private void addDoorStatus(String status) {
        if (this.sensor != null) {
            Map data = ((Payment)this.environment.getPack().getPayments().get(0)).getData();
            data.put("door_status", new InputElement("door_status", "\u0421\u0442\u0430\u0442\u0443\u0441 \u0434\u0432\u0435\u0440\u0446\u044b", status));
        }
    }

    class LocalSensorListener
    implements SensorsListener {
        LocalSensorListener() {
        }

        public void onChange(SensorEvent se) {
            if (se.getValue() == 0) {
                PMLoadPaymentModule.this.removeListener();
                PMLoadPaymentModule.this.addDoorStatus("\u0414\u0432\u0435\u0440\u0446\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0430");
                PMLoadPaymentModule.this.process(0, false);
            }
        }
    }

    class CellNumberRequest
    extends Task {
        CellNumberRequest() {
        }

        protected String getWaitId() {
            return "network.request";
        }

        protected Object execute() throws Exception {
            PMLoadPaymentModule.this.log.info((Object)"Start process online request");
            return FxEnv.getConnector().request(PMHelper.createCellNumberRequest(PMLoadPaymentModule.this.environment.getPack()));
        }

        protected void onResult(Object result) {
            PMLoadPaymentModule.this.log.info((Object)("Result: " + result));
            Payment p = (Payment)PMLoadPaymentModule.this.environment.getPack().getPayments().get(0);
            p.setData(ContextHelper.mergeData((Map)p.getData(), PMHelper.extractData(result)));
            int cellNumber = PMHelper.extractCellNumber(result);
            PMLoadPaymentModule.this.log.info((Object)("Cell number: " + cellNumber));
            if (cellNumber == -1) {
                PMLoadPaymentModule.this.log.info((Object)"Cell number isn't set. Show error dialog");
                String errorText = PMHelper.extractErrorText(result);
                PMLoadPaymentModule.this.log.info((Object)("Error text: " + errorText));
                Dialog.show((DialogDescriptor)PMHelper.createErrorDDExtMsg(errorText), actionId -> {
                    PMLoadPaymentModule.this.log.info((Object)("action: " + actionId));
                    if (actionId == 0) {
                        PMLoadPaymentModule.this.cancel((Intent)new BackIntent((Restorable)PMLoadPaymentModule.this.environment.getModules().getSavePamentTemplateModule()));
                    } else {
                        PMLoadPaymentModule.this.cancel((Intent)new ExitIntent(null, 2, 1));
                    }
                });
            } else {
                int cellNumberTmp = cellNumber;
                PMLoadPaymentModule.this.sensor = PMHelper.getSensor(cellNumber);
                if (PMLoadPaymentModule.this.sensor == null) {
                    PMLoadPaymentModule.this.log.info((Object)"Error on get sensor");
                    FxEnv.getConnector().sendEvent(new Event[]{new Event(EventType.Sensor, "Error on getting sensor")});
                    Dialog.show((String)"module/input/error_exit");
                } else {
                    PMLoadPaymentModule.this.log.info((Object)"Show success dialog");
                    Dialog.show((DialogDescriptor)PMHelper.createCellNumberLoadSuccessDD(cellNumber), actionId -> {
                        try {
                            PMLoadPaymentModule.this.log.info((Object)("Add sensor listener to cell " + cellNumberTmp));
                            PMLoadPaymentModule.this.sensor.addListener(PMLoadPaymentModule.this.sl);
                            PMLoadPaymentModule.this.log.info((Object)"Send open door command");
                            PMHelper.setDoorTask(FxEnv.getIOController().getDoorApi().openDoor(cellNumberTmp));
                            FxEnv.showScreen((Screen)PMLoadPaymentModule.this.sumScreen);
                        }
                        catch (IOControllerException ex) {
                            PMLoadPaymentModule.this.log.error((Object)ex, (Throwable)ex);
                            PMHelper.stopOpeningDoor();
                            FxEnv.getConnector().sendEvent(new Event[]{new Event(EventType.Sensor, "Error on open door: " + ex.getMessage())});
                            Dialog.show((DialogDescriptor)PMHelper.createOpenDoorErrorDD(), i -> PMLoadPaymentModule.this.cancel((Intent)new ExitIntent(null, 2, 1)));
                        }
                    });
                }
            }
        }

        protected void onError(Exception ex) {
            PMLoadPaymentModule.this.log.error((Object)ex, (Throwable)ex);
            PMLoadPaymentModule.this.log.info((Object)"Show error dialog");
            Dialog.show((DialogDescriptor)PMHelper.createCellNumberLoadErrorDD(), actionId -> {
                PMLoadPaymentModule.this.log.info((Object)("action: " + actionId));
                if (actionId == 0) {
                    PMLoadPaymentModule.this.cancel((Intent)new BackIntent((Restorable)PMLoadPaymentModule.this.environment.getModules().getSavePamentTemplateModule()));
                } else {
                    PMLoadPaymentModule.this.cancel((Intent)new ExitIntent(null, 2, 1));
                }
            });
        }

        public String toString() {
            return "CellNumberRequest{}";
        }
    }

    class CashScreenListener
    extends BaseScreenListener {
        CashScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            PMLoadPaymentModule.this.log.info((Object)("Action on sum screen: " + action));
            if (ActionType.isNext((String)action)) {
                PMLoadPaymentModule.this.process(0, false);
            } else {
                PMLoadPaymentModule.this.process(1, false);
            }
        }
    }
}

