/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payment;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.module.Pack;
import fxterm.module.Payment;
import fxterm.session.Session;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import plfx.msg.MessageTemplate;
import plfx.msg.SimpleMessageTemplate;
import plfx.msg.screen.ScreenProcessor;
import plfx.screen.popup.dialog.DialogButton;
import plfx.screen.popup.dialog.DialogDescriptor;
import ru.softlogic.cash.Sum;
import ru.softlogic.hdw.dev.ioc.DoorTask;
import ru.softlogic.hdw.dev.ioc.IOController;
import ru.softlogic.hdw.dev.ioc.IOControllerException;
import ru.softlogic.hdw.dev.sensors.Sensor;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.request.RequestData;
import ru.softlogic.input.model.advanced.actions.request.Response;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.srv.DataItem;
import ru.softlogic.srv.api.operation.ProcessingResult;
import ru.softlogic.srv.api.operation.ProcessingResultType;

public class PMHelper {
    private static final Logger log = LoggerId.PAY;
    private static final String FUNC_CHECK_NUMBER = "check-number";
    private static final String TERMINAL_VERSION = (String)Session.getData().get("terminal_version");
    private static final String SERIAL_NUMBER = "serial_number";
    private static final String SERIAL_NUMBER_PRINT = "serial_number_print";
    private static final String SERIAL_NUMBER_TITLE = "\u0421\u0435\u0440\u0438\u0439\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440";
    private static final String SOFTWARE_VERSION = "software_version";
    private static final String SOFTWARE_VERSION_TITLE = "\u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e";
    private static final String ID1_COPY = "id1_copy";
    private static final String ID2_COPY = "id2_copy";
    private static final String ERROR_TEXT = "#errorText";
    public static final String CELL_NUMBER = "cell_position";
    public static final String SUM_PURCHASE = "summ";
    private static volatile DoorTask doorTask;

    public static RequestData createSumPurchaseRequest(Pack pack) {
        return PMHelper.createCellNumberRequest(pack);
    }

    public static RequestData createCellNumberRequest(Pack pack) {
        if (pack != null) {
            Map data = ((Payment)pack.getPayments().get(0)).getData();
            HashMap<String, String> form = new HashMap<String, String>();
            form.put(SERIAL_NUMBER, PMHelper.getSerialBase64());
            form.put(SOFTWARE_VERSION, TERMINAL_VERSION);
            form.put("id1", PMHelper.getValue(data, "id1"));
            String tmp = PMHelper.getValue(data, "id2");
            if (tmp != null) {
                form.put("id2", tmp);
            }
            RequestData rd = new RequestData();
            rd.setFunction(FUNC_CHECK_NUMBER);
            rd.setIdService(pack.getService().getId());
            Dealer provider = pack.getService().getProvider();
            if (provider != null) {
                rd.setIdProvider(provider.getId());
            }
            rd.setParams(form);
            return rd;
        }
        return null;
    }

    public static int extractCellNumber(Object obj) {
        int cellNumber;
        block8: {
            ProcessingResult pr;
            DataItem[] dis;
            block7: {
                cellNumber = -1;
                if (!(obj instanceof Response)) break block7;
                Response r = (Response)obj;
                if (r.getServerError() != 0 || r.getServiceError() != 0 || r.getData() == null || ((Data)r.getData()).getElements() == null) break block8;
                for (InputElement ie : ((Data)r.getData()).getElements()) {
                    if (!CELL_NUMBER.equals(ie.getKey())) continue;
                    try {
                        return Integer.parseInt(ie.getValue());
                    }
                    catch (NumberFormatException ex) {
                        log.error((Object)ex);
                    }
                }
                break block8;
            }
            if (obj instanceof ProcessingResult && (dis = (pr = (ProcessingResult)obj).getDataItems()) != null) {
                for (DataItem di : dis) {
                    if (!CELL_NUMBER.equals(di.getKey())) continue;
                    try {
                        return Integer.parseInt(di.getValue());
                    }
                    catch (NumberFormatException ex) {
                        log.error((Object)ex);
                    }
                }
            }
        }
        return cellNumber;
    }

    public static Map<String, Object> extractData(Object obj) {
        HashMap<String, Object> r;
        block4: {
            ProcessingResult pr;
            block3: {
                r = new HashMap<String, Object>();
                if (!(obj instanceof Response)) break block3;
                Response resp = (Response)obj;
                if (resp.getServerError() != 0 || resp.getServiceError() != 0 || resp.getData() == null || ((Data)resp.getData()).getElements() == null) break block4;
                for (InputElement ie : ((Data)resp.getData()).getElements()) {
                    r.put(ie.getKey(), ie);
                }
                break block4;
            }
            if (obj instanceof ProcessingResult && (pr = (ProcessingResult)obj).getType() == ProcessingResultType.Ok && pr.getDataItems() != null) {
                for (DataItem di : pr.getDataItems()) {
                    r.put(di.getKey(), new InputElement(di.getKey(), di.getKey(), di.getValue(), di.getValue(), 0));
                }
            }
        }
        return r;
    }

    public static String extractErrorText(Object obj) {
        String errorText = "";
        if (obj instanceof Response) {
            Response resp = (Response)obj;
            if (resp.getData() != null && ((Data)resp.getData()).getElements() != null) {
                for (InputElement ie : ((Data)resp.getData()).getElements()) {
                    if (!ERROR_TEXT.equals(ie.getKey())) continue;
                    errorText = ie.getValue();
                }
            }
        } else if (obj instanceof ProcessingResult) {
            ProcessingResult pr = (ProcessingResult)obj;
            errorText = pr.getErrorText();
        }
        return errorText;
    }

    public static Sum extractSumPurchase(Response<Data> source) {
        Sum res = null;
        if (source.getData() != null && ((Data)source.getData()).getElements() != null) {
            for (InputElement ie : ((Data)source.getData()).getElements()) {
                if (!SUM_PURCHASE.equals(ie.getKey()) || !ie.getValue().matches("^\\d+(\\.\\d{0,2})?")) continue;
                try {
                    return new Sum((int)(Double.parseDouble(ie.getValue()) * 100.0), Session.getInCurrency());
                }
                catch (NumberFormatException ex) {
                    log.error((Object)ex);
                }
            }
        }
        return res;
    }

    public static Sensor getSensor(int cellNumber) {
        IOController ioc = FxEnv.getIOController();
        return ioc.getSensors().stream().filter(s -> s.getId() == cellNumber).findFirst().get();
    }

    public static void preparePayment(Payment p) {
        if (p == null || p.getData() == null) {
            return;
        }
        p.getData().put(SERIAL_NUMBER, new InputElement(SERIAL_NUMBER, SERIAL_NUMBER_TITLE, PMHelper.getSerialBase64(), 2));
        p.getData().put(SERIAL_NUMBER_PRINT, new InputElement(SERIAL_NUMBER_PRINT, SERIAL_NUMBER_TITLE, PMHelper.getSerial(), 4));
        p.getData().put(SOFTWARE_VERSION, new InputElement(SOFTWARE_VERSION, SOFTWARE_VERSION_TITLE, TERMINAL_VERSION, 2));
        PMHelper.copyAttr("id1", ID1_COPY, p);
        PMHelper.copyAttr("id2", ID2_COPY, p);
    }

    private static String getSerial() {
        DeviceInfo di;
        String res = null;
        IOController ioc = FxEnv.getIOController();
        if (ioc != null && (di = ioc.getLastInfo()) != null) {
            res = di.getSerial();
        }
        return res;
    }

    private static String getSerialBase64() {
        String serial = PMHelper.getSerial();
        if (serial == null) {
            return null;
        }
        return new String(Base64.encodeBase64((byte[])serial.getBytes()));
    }

    private static void copyAttr(String srcId, String copyId, Payment p) {
        if (p == null || p.getData() == null) {
            return;
        }
        Object obj = p.getData().get(srcId);
        if (obj instanceof InputElement) {
            InputElement ie = (InputElement)obj;
            InputElement ieCopy = new InputElement(ie);
            ieCopy.setKey(copyId);
            ieCopy.addFlag(2);
            p.getData().put(copyId, ieCopy);
        }
    }

    private static String getValue(Map<String, Object> data, String key) {
        Object obj;
        if (data != null && key != null && !key.trim().isEmpty() && (obj = data.get(key)) instanceof InputElement) {
            InputElement ie = (InputElement)obj;
            return ie.getValue();
        }
        return null;
    }

    public static DialogDescriptor createSumPurchaseErrorDD() {
        return PMHelper.createErrorDD("pochtomat_sum_purchase_error");
    }

    public static DialogDescriptor createCellNumberLoadErrorDD() {
        return PMHelper.createErrorDD("pochtomat_cell_number_error");
    }

    private static DialogDescriptor createErrorDD(String message) {
        DialogButton[] db = new DialogButton[2];
        SimpleMessageTemplate smt = new SimpleMessageTemplate("button_back");
        ScreenProcessor.process((String)"skin", (MessageTemplate)smt);
        db[0] = new DialogButton(smt.getValue(), "", "", 0);
        smt = new SimpleMessageTemplate("button_exit");
        ScreenProcessor.process((String)"skin", (MessageTemplate)smt);
        db[1] = new DialogButton(smt.getValue(), "", "", 1);
        smt = new SimpleMessageTemplate(message);
        ScreenProcessor.process((String)"skin", (MessageTemplate)smt);
        DialogDescriptor dd = new DialogDescriptor("", "skin", smt.getValue(), "default_2x", "error", 15, db, 1, "skin");
        return dd;
    }

    public static DialogDescriptor createErrorDDExtMsg(String message) {
        DialogButton[] db = new DialogButton[2];
        SimpleMessageTemplate smt = new SimpleMessageTemplate("button_back");
        ScreenProcessor.process((String)"skin", (MessageTemplate)smt);
        db[0] = new DialogButton(smt.getValue(), "", "", 0);
        smt = new SimpleMessageTemplate("button_exit");
        ScreenProcessor.process((String)"skin", (MessageTemplate)smt);
        db[1] = new DialogButton(smt.getValue(), "", "", 1);
        DialogDescriptor dd = new DialogDescriptor("", "skin", message, "default_2x", "error", 15, db, 1, "skin");
        return dd;
    }

    public static DialogDescriptor createCellNumberDispenseErrorDD() {
        DialogButton[] db = new DialogButton[1];
        SimpleMessageTemplate smt = new SimpleMessageTemplate("button_exit");
        ScreenProcessor.process((String)"skin", (MessageTemplate)smt);
        db[0] = new DialogButton(smt.getValue(), "", "", 0);
        smt = new SimpleMessageTemplate("pochtomat_cell_number_error");
        ScreenProcessor.process((String)"skin", (MessageTemplate)smt);
        DialogDescriptor dd = new DialogDescriptor("", "skin", smt.getValue(), "default_1x", "error", 15, db, 0, "skin");
        return dd;
    }

    public static DialogDescriptor createOpenDoorErrorDD() {
        DialogButton[] db = new DialogButton[1];
        SimpleMessageTemplate smt = new SimpleMessageTemplate("button_exit");
        ScreenProcessor.process((String)"skin", (MessageTemplate)smt);
        db[0] = new DialogButton(smt.getValue(), "", "", 0);
        smt = new SimpleMessageTemplate("pochtomat_open_door_error");
        ScreenProcessor.process((String)"skin", (MessageTemplate)smt);
        DialogDescriptor dd = new DialogDescriptor("", "skin", smt.getValue(), "default_1x", "error", 15, db, 1, "skin");
        return dd;
    }

    public static DialogDescriptor createCellNumberLoadSuccessDD(int cellNumber) {
        return PMHelper.createCellNumberSuccessDD(cellNumber, "pochtomat_cell_number_load");
    }

    public static DialogDescriptor createCellNumberDispenseSuccessDD(int cellNumber) {
        return PMHelper.createCellNumberSuccessDD(cellNumber, "pochtomat_cell_number_dispense");
    }

    private static DialogDescriptor createCellNumberSuccessDD(int cellNumber, String messageId) {
        DialogButton[] db = new DialogButton[1];
        SimpleMessageTemplate smt = new SimpleMessageTemplate("button_next");
        ScreenProcessor.process((String)"skin", (MessageTemplate)smt);
        db[0] = new DialogButton(smt.getValue(), "", "", 0);
        smt = new SimpleMessageTemplate(messageId);
        ScreenProcessor.process((String)"skin", (MessageTemplate)smt);
        DialogDescriptor dd = new DialogDescriptor("", "skin", MessageFormat.format(smt.getValue(), cellNumber), "default_1x", "success", 15, db, 1, "skin");
        return dd;
    }

    public static DoorTask getDoorTask() {
        return doorTask;
    }

    public static void setDoorTask(DoorTask doorTask) {
        PMHelper.doorTask = doorTask;
    }

    public static void stopOpeningDoor() {
        if (doorTask != null) {
            try {
                doorTask.cancel();
                doorTask = null;
            }
            catch (IOControllerException ex) {
                log.warn((Object)ex);
            }
        }
    }
}

