/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payment;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.core.AppSumFormatter;
import fxterm.core.BaseCommissionCalculator;
import fxterm.core.BaseScreenListener;
import fxterm.core.hdw.bvr.CashManager;
import fxterm.core.hdw.bvr.oper.BaseCashInOperation;
import fxterm.core.hdw.bvr.oper.FraudListener;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.hdw.bvr.oper.OperationFactory;
import fxterm.core.hdw.bvr.oper.SumLimits;
import fxterm.core.task.Task;
import fxterm.module.Environment;
import fxterm.module.ExitIntent;
import fxterm.module.Intent;
import fxterm.module.ModuleHelper;
import fxterm.module.Pack;
import fxterm.module.PackUtility;
import fxterm.module.Payment;
import fxterm.module.Restorable;
import fxterm.module.card.CardModuleHandler;
import fxterm.module.input.adv.AdvancedInputModule;
import fxterm.module.stage.payment.BackIntent;
import fxterm.module.stage.payment.BasePaymentModule;
import fxterm.module.stage.payment.Helper;
import fxterm.module.stage.payment.KeeperListener;
import fxterm.module.stage.payment.PMHelper;
import fxterm.session.Session;
import fxterm.utils.FinUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import plfx.AudioPlayerFx;
import plfx.GuiNotifier;
import plfx.screen.Screen;
import plfx.screen.ScreenListener;
import plfx.screen.pay.CommonSumScreen;
import plfx.screen.popup.dialog.DialogDescriptor;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hdw.dev.cashacc.CashInOperation;
import ru.softlogic.hdw.dev.cashacc.CashInOperationListener;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.advanced.actions.request.Response;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.reference.References;
import ru.softlogic.reference.fraud.FraudControlRule;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.service.comission.SumResult;

public class PMDispensePaymentModule
extends BasePaymentModule {
    protected Environment environment;
    protected Runnable cancelListener;
    protected Sum max;
    protected final CashManager cm = FxEnv.getCashManager();
    protected BaseCashInOperation cashInOperation;
    protected KeeperListener listener;
    private boolean init;
    private Pack restore;

    public void _startPayment(Environment environment, CommonSumScreen sumScreen, Pack restore) {
        this.environment = environment;
        this.restore = restore;
        this.init = false;
        Service s = Session.getService();
        Pack pack = environment.getPack();
        PackUtility.printPack((String)"Payment pack", (Pack)pack);
        FraudControlRule fcr = ModuleHelper.getFraudControlRule((int)Session.getService().getId());
        pack.setFraudControlRule(fcr);
        Sum maxDepositSum = pack.getMaxDepositSum();
        if (maxDepositSum == null) {
            maxDepositSum = s.getMaxInputSum();
        }
        if (maxDepositSum == null) {
            maxDepositSum = s.getMaxSum();
        }
        Sum min = s.getMinSum();
        if (!(pack.getMinSum() == null || pack.getMinSum().isEmpty() || min != null && min.compareTo(pack.getMinSum()) >= 0)) {
            min = pack.getMinSum();
        }
        SumLimits sumLimits = new SumLimits(min, pack.getMinSumWithNoteLimit(), pack.getMaxDepositSum(), maxDepositSum);
        this.log.info((Object)("Limits: " + sumLimits));
        this.cashInOperation = OperationFactory.createDefaultOperation((NewKeeper2)Session.getPayEnv().getKeeper(), (SumLimits)sumLimits, (String)PackUtility.getToken((Pack)pack));
        this.cashInOperation.addFraudListener((FraudListener)new DefaultFraudListener(fcr));
        new SumPurchaseRequest(sumScreen).process();
    }

    public void initPaymentSchema() {
        if (this.init) {
            int schemaFlags = Session.getService().getPaymentSchemaFlags();
            boolean isCashSource = (schemaFlags & 1) != 0;
            boolean isCbcSource = (schemaFlags & 2) != 0;
            boolean isShowCashback = true;
            if (References.getPointOptions() != null && !References.getPointOptions().isShowCashback()) {
                isShowCashback = false;
            }
            if (isCashSource && isCbcSource) {
                this.log.info((Object)"Enable cash devices and cashback card button");
                this.enableCashManager();
                Session.setItem((String)"cbcButtonDisable", (Object)false);
                Session.setItem((String)"cbcButtonVisible", (Object)isShowCashback);
            } else if (isCashSource) {
                this.log.info((Object)"Enable cash devices");
                this.enableCashManager();
                Session.setItem((String)"cbcButtonDisable", (Object)true);
                Session.setItem((String)"cbcButtonVisible", (Object)isShowCashback);
            } else {
                this.log.info((Object)"Enable cashback card button");
                Session.setItem((String)"cbcButtonDisable", (Object)false);
                Session.setItem((String)"cbcButtonVisible", (Object)true);
            }
            Session.notifyUpdate();
        } else {
            this.log.warn((Object)"Skip init payment schema");
        }
    }

    public boolean canRedirect() {
        this.log.info((Object)"Request for permission to redirect from PaymentModule");
        if (this.cashInOperation.getSum().isEmpty()) {
            this.log.info((Object)"Keeper is empty. Disable cash devices");
            this.cm.disable(true);
            if (this.cashInOperation.getSum().isEmpty()) {
                this.log.info((Object)"Keeper is empty. Process redirect");
                return true;
            }
            this.log.info((Object)"Current keeper is not empty");
            this.initPaymentSchema();
            return false;
        }
        this.log.info((Object)"Current keeper is not empty. Skip redirect");
        return false;
    }

    protected void enableCashManager() {
        this.cm.enable((CashInOperation)this.cashInOperation);
    }

    public void cancel(Intent intent) {
        boolean timeout;
        this.log.info((Object)("Cancel was requested on payment module, intent =" + intent.getType()));
        boolean bl = timeout = intent.getType() == 0;
        if (timeout) {
            this.log.info((Object)"Payment cancel by timeout");
            Session.getPaymentEndingState().setChType(-1);
        }
        if (this.cashInOperation.getSum().isEmpty()) {
            this.log.info((Object)"Keeper is empty. Disable cash devices");
            this.cm.disable(true);
            if (this.cashInOperation.getSum().isEmpty()) {
                this.log.info((Object)"Keeper is empty. Process intent");
                CardModuleHandler cmh = FxEnv.getCardModuleHandler();
                if (cmh != null && cmh.getCashRequireListener() != null) {
                    cmh.getCashRequireListener().onCancel();
                }
                if (cmh != null && cmh.getBankCashRequireListener() != null) {
                    cmh.getBankCashRequireListener().onCancel();
                }
                if (intent.getType() == 3) {
                    intent.process();
                } else {
                    this.exit();
                }
            } else {
                this.log.info((Object)("New keeper state: " + this.cashInOperation.getSum()));
                if (intent.getType() == 3) {
                    this.log.info((Object)"Can't do back action");
                    this.initPaymentSchema();
                } else if (this.listener.canPay()) {
                    this.log.info((Object)"Payment can be processed, ask question");
                    Dialog.show((String)(timeout ? "module/payment/cash/empty_payment_cancel" : "module/payment/cash/empty_payment_timeout"), actionId -> {
                        this.log.info((Object)("User make choice " + actionId));
                        if (actionId == 0) {
                            this.log.info((Object)"Process cancel");
                            this.process(actionId, timeout);
                        } else {
                            this.initPaymentSchema();
                            this.cancelListener.run();
                        }
                    });
                } else {
                    this.log.info((Object)"Payment can't be processed. Cancel payment");
                    this.process(1, timeout);
                }
            }
        } else {
            this.log.info((Object)"Keeper is not empty. Disable cash devices");
            if (this.listener.canPay()) {
                this.cm.disable(true);
                if (intent.getType() == 3) {
                    this.log.info((Object)"Process BACK intent");
                    intent.process();
                } else {
                    this.log.info((Object)"The amount is sufficient for the payment, ask question");
                    Dialog.show((String)(timeout ? "module/payment/cash/filled_payment_cancel" : "module/payment/cash/filled_payment_timeout"), actionId -> {
                        this.log.info((Object)("User make choice " + actionId));
                        this.process(actionId, timeout);
                    });
                }
            } else {
                this.cm.disable(true);
                if (intent.getType() == 3) {
                    this.log.info((Object)"Process BACK intent");
                    intent.process();
                } else {
                    this.log.info((Object)"The amount is NOT sufficient for the payment, ask question");
                    Dialog.show((String)"module/payment/cash/cancel_continue", actionId -> {
                        this.log.info((Object)("User make choice " + actionId));
                        if (actionId == 0) {
                            this.initPaymentSchema();
                            this.cancelListener.run();
                        } else {
                            this.process(actionId, timeout);
                        }
                    });
                }
            }
        }
    }

    protected void processSum0() {
        Sum s0;
        this.log.info((Object)("Begin process payment, keeper=" + this.cashInOperation.getSum()));
        Pack pack = this.environment.getPack();
        Sum change = s0 = FinUtils.createVoidSum();
        if (!this.cashInOperation.getKeeper().isEmpty()) {
            change = new Sum(this.cashInOperation.getSum());
        }
        SumResult sumResult = new SumResult(s0, s0, s0, s0, s0, change, null);
        pack.setSumResult(sumResult);
        this.log.info((Object)"Process single operation pack");
        Payment p = (Payment)pack.getPayments().get(0);
        this.log.info((Object)"Set zero amount flag");
        pack.setZeroAmount(true);
        p.setSumOut(sumResult.getOut());
        PMHelper.preparePayment(p);
        Session.getPaymentEndingState().setCancel(false);
        this.startPayout(this.environment);
    }

    protected void process(int actionId, boolean timeout) {
        this.log.info((Object)("Begin process payment, actionId=" + actionId + ", timeout=" + timeout + ", keeper=" + this.cashInOperation.getSum()));
        if (this.cashInOperation.getKeeper().isEmpty()) {
            GuiNotifier.notifyProblem((String)"#001");
            this.log.error((Object)"Double click?");
            return;
        }
        Pack pack = this.environment.getPack();
        this.log.info((Object)"Update SumResult");
        SumResult sumResult = this.listener.getResult();
        pack.setSumResult(sumResult);
        pack.setFixedSum(this.listener.isFixedSum());
        Service s = Session.getService();
        Sum divSum = s.getDivideSum();
        if (divSum != null && !divSum.isEmpty() && actionId == 0 && pack.getPayments().size() == 1) {
            Sum totalInput = sumResult.getOut();
            this.log.info((Object)("\u041e\u0431\u0449\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 " + totalInput + ", \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0440\u0430\u0437\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430 \u0441\u0443\u043c\u043c\u044b: " + divSum));
            int count = totalInput.getValue() / divSum.getValue();
            if (!divSum.mul((double)count).equals((Object)totalInput)) {
                ++count;
            }
            --count;
            Payment payment = (Payment)pack.getPayments().get(0);
            payment.setOperationSum(divSum);
            for (int i = 0; i < count; ++i) {
                Payment payment1 = new Payment();
                payment1.setData(payment.getData());
                payment1.setOperationSum(divSum);
                pack.getPayments().add(payment1);
            }
            pack.setSumDistributionType("consistent");
        }
        if (pack.getPayments().size() == 1) {
            this.log.info((Object)"Process single operation pack");
            Payment p2 = (Payment)pack.getPayments().get(0);
            if (actionId == 0) {
                p2.setSumOut(sumResult.getOut());
                PMHelper.preparePayment(p2);
                Session.getPaymentEndingState().setCancel(false);
            } else {
                PackUtility.cancelPack((Pack)pack);
                p2.setSumOut(FinUtils.createVoidSum());
                Session.getPaymentEndingState().setCancel(true);
            }
        } else if (s.getDivideSum() != null && !s.getDivideSum().isEmpty() || s.getDivideSumFrom() != null && !s.getDivideSumFrom().isEmpty() && s.getDivideSumTo() != null && !s.getDivideSumTo().isEmpty()) {
            this.log.info((Object)"Process divide operation pack");
            if (actionId == 0) {
                PackUtility.setGroupIds((List)pack.getPayments());
                pack.setSumResult(sumResult);
                Session.getPaymentEndingState().setCancel(false);
            } else {
                PackUtility.cancelPack((Pack)pack);
                Session.getPaymentEndingState().setCancel(true);
            }
        } else {
            this.log.info((Object)("Pack size: " + pack.getPayments().size()));
            if (actionId == 0) {
                if (Boolean.TRUE.equals(s.getGpDivComm()) && PackUtility.getPaymentSums((List)pack.getPayments()) != null) {
                    PackUtility.setGroupIds((List)pack.getPayments());
                    pack.setSumResult(sumResult);
                    Session.getPaymentEndingState().setCancel(false);
                } else {
                    pack.setSumResult(sumResult);
                    PackUtility.distributeSum((Pack)pack, (SumResult)sumResult);
                    PackUtility.setGroupIds((List)pack.getPayments());
                    Session.getPaymentEndingState().setCancel(false);
                }
                pack.getPayments().stream().forEach(p -> PMHelper.preparePayment(p));
            } else {
                PackUtility.cancelPack((Pack)pack);
                Session.getPaymentEndingState().setCancel(true);
            }
        }
        this.startPayout(this.environment);
    }

    private void startPayment(Sum opr, CommonSumScreen sumScreen) {
        Pack pack = this.environment.getPack();
        pack.setOperationSum(opr);
        String curr = Session.getInCurrency();
        Service s = Session.getService();
        MenuItem mi = Session.getActiveItem();
        Commission c = Session.getCommission();
        Session.setPayments((List)pack.getPayments());
        Sum maxSumPurchase = (Sum)Session.getData().get("max_sum_purchase");
        Sum min = s.getMinSum();
        if (pack.getMinSum() != null && !pack.getMinSum().isEmpty()) {
            min = pack.getMinSum();
        }
        this.max = s.getMaxInputSum();
        if (pack.getMaxSum() != null && !pack.getMaxSum().isEmpty()) {
            this.max = pack.getMaxSum();
        }
        if (this.max == null || this.max.isEmpty()) {
            this.max = s.getMaxSum();
        }
        if (this.max == null || this.max.isEmpty()) {
            GuiNotifier.notifyProblemOnce((String)("Max sum is not set for service: " + Session.getService().getName() + "," + Session.getService().getId()));
            this.exit(new IllegalArgumentException("Max sum is not set for service: " + Session.getService().getName() + "," + Session.getService().getId()));
            return;
        }
        if (min == null || min.isEmpty()) {
            min = new Sum(1, curr);
        }
        if (!opr.isEmpty() && opr.compareTo(min) < 0) {
            this.log.info((Object)("Fix min sum to=" + opr));
            min = opr;
        }
        Sum requireSum = null;
        if (!opr.isEmpty()) {
            requireSum = BaseCommissionCalculator.calculate((Sum)opr, (Commission)c, (Service)s, (boolean)mi.isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee());
        }
        if (requireSum == null) {
            requireSum = BaseCommissionCalculator.calculate((Sum)min, (Commission)c, (Service)s, (boolean)mi.isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee());
        }
        this.log.info((Object)"Sums restrictions");
        this.log.info((Object)("\tMin      : " + AppSumFormatter.asStr((Sum)min) + "(in srv=" + AppSumFormatter.asStr((Sum)s.getMinSum()) + ")"));
        this.log.info((Object)("\tMax      : " + AppSumFormatter.asStr((Sum)this.max)));
        this.log.info((Object)("\tOperation: " + AppSumFormatter.asStr((Sum)opr)));
        this.log.info((Object)("\tRequired : " + AppSumFormatter.asStr((Sum)requireSum)));
        this.log.info((Object)("\tMax pay  : " + AppSumFormatter.asStr((Sum)s.getMaxSum())));
        this.log.info((Object)("\tMax input: " + AppSumFormatter.asStr((Sum)s.getMaxInputSum())));
        this.log.info((Object)("\tMax sum purchase: " + AppSumFormatter.asStr((Sum)maxSumPurchase)));
        Session.setItem((String)"sum_max", (Object)this.max);
        Set hdw = this.cm.getHdwDenomination(curr);
        this.log.info((Object)"Supported hardware denominations:");
        if (hdw != null) {
            hdw.stream().forEach(dn -> this.log.info((Object)("\tid=" + dn.getId() + ", " + (dn.getType() == 0 ? "NOTE" : "COIN") + ", " + dn.getNominal() + ", " + dn.getCurrency())));
        }
        this.log.info((Object)"Another options");
        this.log.info((Object)("\tDisable exit on depositing funds: " + s.isFlagExist(8L)));
        this.log.info((Object)("\tNot take money reaches amount   : " + s.getNotTakeMoneyReachesAmount()));
        if (maxSumPurchase != null && !maxSumPurchase.isEmpty() && requireSum.compareTo(this.max) > 0) {
            String errorMsg = "Required sum exceeds the MAX_SUM = " + AppSumFormatter.asStr((Sum)this.max) + ". Service id:" + s.getId() + ". Required sum: " + AppSumFormatter.asStr((Sum)requireSum);
            if (this.environment.getModules().getInputModule() instanceof AdvancedInputModule) {
                Session.getPayEnv().setPack(this.restore);
                Dialog.show((String)"module/payment/cash/exceeds_sum", actionId -> this.cancel((Intent)new BackIntent((Restorable)this.environment.getModules().getSavePamentTemplateModule())));
            } else {
                this.exit(new IllegalArgumentException(errorMsg));
            }
            return;
        }
        this.listener = new KeeperListener(this.cashInOperation, c, s, min, this.max, requireSum, opr, sumScreen, mi.isIgnoreMinMaxCommission(), pack.isAllowReturn(), pack.getProviderFee());
        this.listener.updateViews();
        this.cashInOperation.addOperationListener((CashInOperationListener)this.listener);
        sumScreen.setListener((ScreenListener)new CashScreenListener());
        FxEnv.showScreen((Screen)sumScreen);
        AudioPlayerFx.getInstance().play("pay_data.mp3");
        this.init = true;
        this.initPaymentSchema();
    }

    protected void onUnknownAction(String action, Map<String, Object> data, Runnable cancelListener) {
        cancelListener.run();
        GuiNotifier.notifyProblem((String)("Unknown action on sumscreen: " + action));
    }

    class DefaultFraudListener
    implements FraudListener {
        private final FraudControlRule fcr;

        public DefaultFraudListener(FraudControlRule fcr) {
            this.fcr = fcr;
        }

        public void onFraudAttempt() {
            if (this.fcr == null) {
                PMDispensePaymentModule.this.log.info((Object)"Fraud-control: disable");
                return;
            }
            Integer minNominalNote = this.fcr.getMinNominalNote() == 0 ? null : Integer.valueOf(this.fcr.getMinNominalNote());
            Integer timeout = this.fcr.getTimeout() == 0 ? null : Integer.valueOf(this.fcr.getTimeout());
            PMDispensePaymentModule.this.log.info((Object)("Fraud min nominal      : " + minNominalNote));
            PMDispensePaymentModule.this.log.info((Object)("Fraud timeout          : " + timeout));
            PMDispensePaymentModule.this.log.info((Object)("Fraud optional success : " + this.fcr.isOptionalSuccess()));
            if (minNominalNote == null || timeout == null) {
                PMDispensePaymentModule.this.log.info((Object)"Fraud-control: disable");
                return;
            }
            PMDispensePaymentModule.this.log.info((Object)"Fraud-control: enable");
            float amountWeight = 0.0f;
            for (Map.Entry e : PMDispensePaymentModule.this.cashInOperation.getFraudData().entrySet()) {
                amountWeight += BaseCashInOperation.getFraudWeight((int)((Integer)e.getKey())) * (float)((Integer)e.getValue()).intValue();
            }
            if ((double)amountWeight < 1.0) {
                PMDispensePaymentModule.this.log.info((Object)("Fraud warning. Rate: " + amountWeight));
                return;
            }
            PMDispensePaymentModule.this.log.info((Object)("Fraud detect. Rate: " + amountWeight));
            boolean react = false;
            if (this.fcr.isOptionalSuccess()) {
                PMDispensePaymentModule.this.log.info((Object)"isFraudOptionalSuccess(): true");
                react = true;
            } else {
                for (CashUnit value : PMDispensePaymentModule.this.cashInOperation.getKeeper().getInputMap().keySet()) {
                    PMDispensePaymentModule.this.log.info((Object)(value.getType() + "==" + 3 + " | " + value.getNominal().getValue() + " >=" + minNominalNote));
                    if (value.getType() != 3 || value.getNominal().getValue() < minNominalNote) continue;
                    react = true;
                    break;
                }
            }
            if (react) {
                PMDispensePaymentModule.this.log.info((Object)"Reaction on fraud");
                FxEnv.getConnector().getQueue().onFraudDetect();
                PMDispensePaymentModule.this.environment.getPack().setFraud(true);
                Session.setFraudLock((Integer)timeout);
            }
        }
    }

    class CashScreenListener
    extends BaseScreenListener {
        private final Logger log = LoggerId.PAY;
        private final CashManager cm = FxEnv.getCashManager();

        CashScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            this.log.info((Object)("Action on sum screen: " + action));
            PMDispensePaymentModule.this.cancelListener = cancelListener;
            if (ActionType.isCbc((String)action)) {
                this.cm.disable(false);
                Runnable exitToMain = () -> {
                    this.log.info((Object)"Exit to main menu");
                    PMDispensePaymentModule.this.cancel((Intent)new ExitIntent(null, 2, 2));
                };
                Helper.showCbcScreen((BaseCashInOperation)PMDispensePaymentModule.this.cashInOperation, (Runnable)exitToMain, (Runnable)cancelListener);
            } else if (ActionType.isComm((String)action)) {
                this.log.info((Object)"Show commission screen");
                Helper.showComm((Runnable)cancelListener);
            } else if (ActionType.isExit((String)action)) {
                this.log.info((Object)"Exit to main menu");
                PMDispensePaymentModule.this.cancel((Intent)new ExitIntent(null, 2, 2));
            } else if (ActionType.isPrev((String)action)) {
                this.log.info((Object)"Exit to paytpl module");
                PMDispensePaymentModule.this.environment.getPack().setSumResult(PMDispensePaymentModule.this.listener.getResult());
                PMDispensePaymentModule.this.cancel((Intent)new BackIntent((Restorable)PMDispensePaymentModule.this.environment.getModules().getSavePamentTemplateModule()));
            } else if (ActionType.isNext((String)action)) {
                this.cm.disable(true);
                PMDispensePaymentModule.this.process(0, false);
            } else {
                PMDispensePaymentModule.this.onUnknownAction(action, data, cancelListener);
            }
        }
    }

    class SumPurchaseRequest
    extends Task {
        private final CommonSumScreen sumScreen;

        public SumPurchaseRequest(CommonSumScreen sumScreen) {
            this.sumScreen = sumScreen;
        }

        protected String getWaitId() {
            return "network.request";
        }

        protected Object execute() throws Exception {
            PMDispensePaymentModule.this.log.info((Object)"Start process online request");
            return FxEnv.getConnector().request(PMHelper.createSumPurchaseRequest(PMDispensePaymentModule.this.environment.getPack()));
        }

        protected void onResult(Object result) {
            Response r;
            PMDispensePaymentModule.this.log.info((Object)("Result: " + result));
            if (result instanceof Response && (r = (Response)result).getServerError() == 0 && r.getServiceError() == 0) {
                Sum opr = PMHelper.extractSumPurchase((Response<Data>)r);
                PMDispensePaymentModule.this.log.info((Object)("Sum purchase: " + opr));
                if (opr == null || opr.isEmpty()) {
                    PMDispensePaymentModule.this.processSum0();
                } else {
                    PMDispensePaymentModule.this.startPayment(opr, this.sumScreen);
                }
                return;
            }
            String errorText = PMHelper.extractErrorText(result);
            PMDispensePaymentModule.this.log.info((Object)("Error text: " + errorText));
            this.showErrorDialog(PMHelper.createErrorDDExtMsg(errorText));
        }

        protected void onError(Exception ex) {
            PMDispensePaymentModule.this.log.error((Object)ex, (Throwable)ex);
            PMDispensePaymentModule.this.log.info((Object)"Show error dialog");
            this.showErrorDialog(PMHelper.createSumPurchaseErrorDD());
        }

        private void showErrorDialog(DialogDescriptor dd) {
            Dialog.show((DialogDescriptor)dd, actionId -> {
                PMDispensePaymentModule.this.log.info((Object)("action: " + actionId));
                if (actionId == 0) {
                    PMDispensePaymentModule.this.cancel((Intent)new BackIntent((Restorable)PMDispensePaymentModule.this.environment.getModules().getSavePamentTemplateModule()));
                } else {
                    PMDispensePaymentModule.this.cancel((Intent)new ExitIntent(null, 2, 1));
                }
            });
        }

        public String toString() {
            return "SumPurchaseRequest{}";
        }
    }
}

