/*
 * Decompiled with CFR 0.152.
 */
package ru.slkf;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import ru.slkf.KeeperCreatingException;
import ru.slkf.KeeperModule;
import ru.slkf.atm.AtmAPI;

public class KeeperModuleFactory {
    private static final String KEEPER_IMPL_CLASS_PARAM = "keeper.impl.classname";

    public static KeeperModule create(File homePath, Properties config, AtmAPI listener) throws KeeperCreatingException {
        if (config == null) {
            throw new KeeperCreatingException("Properties configuration is null");
        }
        String className = config.getProperty(KEEPER_IMPL_CLASS_PARAM);
        if (className == null) {
            className = "plfx.screen.input.keeper.KeeperModuleImpl";
        }
        try {
            Class<?> cl = Class.forName(className);
            KeeperModule km = (KeeperModule)cl.getConstructor(File.class, Properties.class, AtmAPI.class).newInstance(homePath, config, listener);
            return km;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new KeeperCreatingException(e.getMessage(), e);
        }
    }
}

